#version 330 compatibility
#extension GL_EXT_geometry_shader4 : enable


uniform sampler2D color_tex;
uniform sampler2D shadow_tex;
uniform sampler2D depth_tex;

uniform mat3 un_dir_colors;
uniform float un_timeOfDay;

uniform float un_dens;
uniform float un_fading;

uniform mat4 project_light;
uniform mat4 modelViewMatrix_light;
uniform mat4 viewMatrix_light;
uniform mat4 viewMatrixInv_light;
uniform mat4 viewMatrix;

uniform mat4 ProjectionMatrix;
uniform mat4 light_mv_matrix;

uniform int backtofront;

in vec4 ex_position;
in vec4 ex_texCoord;
//in vec4 ex_ambient;
//in vec4 ex_diffuse;
in vec3 ex_normal;
in vec2 ex_density;
in vec3 p;

in vec3 ex_cloudColor;
in vec3 ex_extinction;
in vec3 ex_inscatter;

uniform vec3 un_sunLight;
uniform vec3 un_light_pos;

out vec4 out_color;
out vec4 out_color2;

vec3 directionalColor(vec3 normal)
{	
	vec4 ex_mie = vec4(1.0);
	vec3 cmin = (un_dir_colors[0]*0.4)+(0.3*clamp(ex_mie.xyz-vec3(0.5, 0.5, 0.5), 0.0, 1.0));
	vec3 cmed = (un_dir_colors[1]*0.7)+(0.3*clamp(ex_mie.xyz-vec3(0.2, 0.2, 0.2), 0.0, 1.0));
	vec3 cmax = (un_dir_colors[2]*0.9)+(0.1*clamp(ex_mie.xyz-vec3(0.0, 0.0, 0.0), 0.0, 1.0));	

	float time_of_day = un_timeOfDay;
	
	vec3 c_t0 = vec3(0.4,0.4,0.4)*normalize(un_sunLight);
	vec3 c_t1 = vec3(1.0,1.0,1.0)*normalize(un_sunLight);

	vec3 sunPosition = un_light_pos;
	sunPosition.xyz = sunPosition.xzy;
	vec3 n1 = normalize(normal);
	vec3 n2 = normalize(un_light_pos);
	float dotres = clamp(dot(n1,n2),0.0,1.0);

	vec3 color;
	if (dotres < 0.0)
	{
		dotres += 1.0;
		color = ((1.0-dotres)*cmin) + (dotres*cmed);
	}
	else
	{
		color = ((1.0-dotres)*cmed) + (dotres*cmax);
	}
	
	return color* ( (1.0-time_of_day) * c_t0 + (1.0-(1.0-time_of_day))*c_t1);
	
}


void main(void)
{
/*
	float index1 = floor(ex_texCoord.z+0.1);
	float findex1_x = int(mod(index1,4.0));
	float findex1_y = int(index1/4.0);	

	float index2 = floor(ex_texCoord.w+0.1);
	//float index2 = 10.0;
	float findex2_x = int(mod(index2,4.0));
	float findex2_y = int(index2/4.0);	
		
	
	vec2 c1 =(vec2(findex1_x, findex1_y)*0.25)   + (ex_texCoord.xy*0.25);
	vec2 t = vec2(texture(color_tex, c1).x);
	float t2 = clamp(t.x,0.0,1.0);	
	vec4 color = vec4(1.0); 	
	color.w *= t2;
	
	vec3 N = vec3(0.0);
    N.xy = ex_texCoord.xy*vec2(2.0, 2.0) - vec2(1.0, 1.0);
    float mag = length(N);   	
    N.z = sqrt(2.0)-(mag);	
	N = normalize(N);		
	//N.y *= -1.0;
	
		
	vec3 lightPos = (inverse(viewMatrix_light) * vec4(0,0,0,1)).xyz;	
	lightPos = normalize(lightPos);
	lightPos.xyz = lightPos.xyz;
		
	const float LOG2 = 1.442695;
	float z = gl_FragCoord.z / gl_FragCoord.w;
	float fogFactor = exp2(-pow(0.00005,2.f) *
							pow(z,2.0) *
							LOG2 );
	fogFactor = clamp(fogFactor, 0.0, 1.0);	
		
	out_color = color;		
	out_color.xyz *= out_color.w;	
	*/
	out_color = vec4(1.0);
	out_color2 = vec4(1.0, 0.0, 0.0, out_color.w);				
}