#version 330 core
uniform mat4 ModelViewMatrix;
uniform mat4 ProjectionMatrix;
uniform mat4 ViewMatrix;

layout (location = 0) in vec4 in_position;
layout (location = 1) in vec4 in_texCoord;
layout (location = 2) in vec4 in_normal;

// vertex-shader output variables (passed to fragment-shader)
out vec2 ex_TexCoords;
out vec4 ex_Vertex;
out vec3 ex_Normal;

void main()
{		
	ex_TexCoords = in_texCoord.st;
	ex_Normal = in_normal.xyz;
	ex_Vertex = (inverse(ViewMatrix) * ModelViewMatrix) * vec4(in_position.xyz,1.0);	
	
	gl_Position = ProjectionMatrix*ModelViewMatrix * vec4(in_position.xyz,1.0);	
}