#version 330 core
uniform mat4 ViewMatrix;
uniform vec3 v3LightPos;		// The direction vector to the light source
uniform vec3 v3InvWavelength;	// 1 / pow(wavelength, 4) for the red, green, and blue channels
uniform float fOuterRadius;		// The outer (atmosphere) radius
uniform float fOuterRadius2;	// fOuterRadius^2
uniform float fInnerRadius;		// The inner (planetary) radius
uniform float fInnerRadius2;	// fInnerRadius^2
uniform float fKrESun;			// Kr * ESun
uniform float fKmESun;			// Km * ESun
uniform float fKr4PI;			// Kr * 4 * PI
uniform float fKm4PI;			// Km * 4 * PI
uniform float fScale;			// 1 / (fOuterRadius - fInnerRadius)
uniform float fScaleDepth;		// The scale depth (i.e. the altitude at which the atmosphere's average density is found)
uniform float fScaleOverScaleDepth;	// fScale / fScaleDepth

uniform sampler2D color_tex;

// uniform shader-parameters
uniform float g;
uniform float g2;

// fragment-shader input variables
in vec2 ex_TexCoords;
in vec4 ex_Vertex;
in vec3 ex_Normal;

// fragment-shader output variable (-> stored in the frame-buffer, i.e. "the pixel you see")
out vec4 out_color;
out vec4 out_color2;

const int nSamples = 20;
const float fSamples = 20.0;

float scale(float fCos)
{
	float x = 1.0 - fCos;
	return fScaleDepth * exp(-0.00287 + x*(0.459 + x*(3.83 + x*(-6.80 + x*5.25))));
}

void main()
{   
	vec4 ex_secondary_color = vec4(0.0);
	vec4 ex_front_color = vec4(0.0);

	//vec3 v3CameraPos = (vec4(0.0, 0.0, 0.0, 1.0)).xyz;
	vec3 v3CameraPos = (inverse(ViewMatrix) * vec4(0.0, 0.0, 0.0, 1.0)).xyz;
		
	vec3 vecCamera = v3CameraPos;
	vecCamera /= 100000.0*fInnerRadius;
	vecCamera.z += fInnerRadius;
	//vecCamera.x = 0.0;
	//vecCamera.y = 0.0;
//	if (vecCamera.z <= fInnerRadius) 
//		vecCamera.z = fInnerRadius + 1.0e-6f;
	
	float fCameraHeight = vecCamera.z;
	float fCameraHeight2 = pow(length(v3CameraPos), 2.f);	
		
	vec3 lightPos = normalize(v3LightPos);

	// Get the ray from the camera to the vertex, and its length (which is the far point of the ray passing through the atmosphere)
	vec3 v3Pos = ex_Vertex.xyz/10000.0*fInnerRadius;
	v3Pos.z += fInnerRadius;
	vec3 v3Ray = v3Pos - vecCamera;
	float fFar = length(v3Ray);
	v3Ray /= fFar;

	// Calculate the ray's starting position, then calculate its scattering offset
	vec3 v3Start = vecCamera;
	float fDepth = exp((fInnerRadius - fCameraHeight) / fScaleDepth);
	float fCameraAngle = dot(-v3Ray, v3Pos) / length(v3Pos);
	float fLightAngle = dot(lightPos, v3Pos) / length(v3Pos);
	float fCameraScale = scale(fCameraAngle);
	float fLightScale = scale(fLightAngle);
	float fCameraOffset = fDepth*fCameraScale;
	float fTemp = (fLightScale + fCameraScale);

	// Initialize the scattering loop variables	
	float fSampleLength = fFar / fSamples;
	float fScaledLength = fSampleLength * fScale;
	vec3 v3SampleRay = v3Ray * fSampleLength;
	vec3 v3SamplePoint = v3Start + (v3SampleRay * 0.5);

	// Now loop through the sample rays
	vec3 v3FrontColor = vec3(0.0);
	vec3 v3Attenuate = vec3(0.0);
	for(int i=0; i<nSamples; i++)
	{
		float fHeight = length(v3SamplePoint);
		float fDepth = exp(fScaleOverScaleDepth * (fInnerRadius - fHeight));
		float fScatter = fDepth*fTemp - fCameraOffset;
		v3Attenuate = exp(-fScatter * (v3InvWavelength * fKr4PI + fKm4PI));
		v3FrontColor += v3Attenuate * (fDepth * fScaledLength);
		v3SamplePoint += v3SampleRay;
	}	

	// Finally, scale the Mie and Rayleigh colors and set up the varying variables for the pixel shader
	ex_secondary_color.rgb = v3Attenuate;
	ex_front_color.rgb = v3FrontColor * (v3InvWavelength * fKrESun + fKmESun);

	//out_color = ex_front_color + texture(color_tex, ex_TexCoords) * ex_secondary_color;	
	//out_color = mix(vec4(0.3, 0.3, 0.3, 1.0), (ex_front_color + ex_secondary_color) * texture(color_tex, ex_TexCoords), fogFactor);	
	out_color = (ex_front_color + ex_secondary_color) * pow(texture(color_tex, ex_TexCoords), vec4(2.2));	
	out_color2 = vec4(0.0, 0.0, 0.0, 1.0);
}

