#version 330 core

// uniform shader-parameters
uniform vec3 v3LightPos;
uniform float g;
uniform float g2;

uniform float fogdensity;
uniform float fogheight;
uniform vec3 fogcolor;

// fragment-shader input variables
in float ex_worldheight;
in vec4 ex_secondary_color;
in vec4 ex_front_color;
in vec3 ex_v3Direction;
//in mat4 ModelViewProjectionMatrix;

// fragment-shader output variable (-> stored in the frame-buffer, i.e. "the pixel you see")
out vec4 out_color;
out vec4 out_color2;


// Calculates the Mie phase function
float getMiePhase(float fCos, float fCos2, float g, float g2)
{
	return 1.5 * ((1.0 - g2) / (2.0 + g2)) * (1.0 + fCos2) / pow(1.0 + g2 - 2.0*g*fCos, 1.5);
}

// Calculates the Rayleigh phase function
float getRayleighPhase(float fCos2)
{
	//return 1.0f;
	return 0.75 + 0.75*fCos2;
}

void main()
{   
	vec3 lightDir = normalize(v3LightPos);

	float fCos = dot(lightDir, ex_v3Direction) / length(ex_v3Direction);
	float fMiePhase = 1.5 * ((1.0 - g2) / (2.0 + g2)) * (1.0 + fCos*fCos) / pow(1.0 + g2 - 2.0*g*fCos, 1.5);
	
	float fCos2 = fCos * fCos;
	out_color = (getRayleighPhase(fCos2) * ex_front_color) + (getMiePhase(fCos, fCos2, g, g2) * ex_secondary_color);
  	
	/*float LOG2 = 1.442695;
	if(ex_worldheight < fogheight)	
	{
		float z = gl_FragCoord.z / gl_FragCoord.w;
		float fogFactor = exp2(-pow(fogdensity,2.f) *
								pow(z,2.0) *
								LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
	
		out_color = mix(vec4(fogcolor.x, fogcolor.y, fogcolor.z, 1.0), out_color, fogFactor);
	}*/
		
	out_color.a = out_color.b;
	
	out_color.w = 1.0;
	//out_color = clamp(out_color, 0.0, 1.0);
	out_color2.xyz = vec3(0.0) + ex_secondary_color.xyz*fMiePhase;
	out_color2 = clamp(out_color2, 0.0, 1.0);

	if(ex_v3Direction.z > 0.0) out_color2 = vec4(0.0, 0.0, 0.0, 1.0);
}

