#version 330 compatibility

// uniform shader-parameters
uniform vec3 v3LightPos;
uniform float g;
uniform float g2;

uniform float fogdensity;
uniform float fogheight;
uniform vec3 fogcolor;

uniform int id;

// fragment-shader input variables
in float ex_worldheight;
in vec4 ex_secondary_color;
in vec4 ex_front_color;
in vec3 ex_v3Direction;
in vec3 ex_lightPos;

// fragment-shader output variable (-> stored in the frame-buffer, i.e. "the pixel you see")
out vec4 out_color;
out vec4 out_color2;


void main()
{   
	vec3 lightDir = normalize(ex_lightPos);

	float fCos = dot(lightDir, ex_v3Direction) / length(ex_v3Direction);
	float fMiePhase = 1.5 * ((1.0 - g2) / (2.0 + g2)) * (1.0 + fCos*fCos) / pow(1.0 + g2 - 2.0*g*fCos, 1.5);
	out_color = ex_front_color + ex_secondary_color*fMiePhase;
	//out_color = clamp(out_color, 0.0, 1.0);
	
	/*float LOG2 = 1.442695;
	if(ex_worldheight < fogheight)	
	{
		float z = gl_FragCoord.z / gl_FragCoord.w;
		float fogFactor = exp2(-pow(fogdensity,2.f) *
								pow(z,2.0) *
								LOG2 );
		fogFactor = clamp(fogFactor, 0.0, 1.0);
	
		out_color = mix(vec4(fogcolor.x, fogcolor.y, fogcolor.z, 1.0), out_color, fogFactor);
	}*/
		
	out_color.a = out_color.b;
	
	out_color.w = 1.0;
	if(out_color.x != out_color.x) out_color.x = 1.0;
	if(out_color.y != out_color.y) out_color.y = 1.0;
	if(out_color.z != out_color.z) out_color.z = 1.0;
	if(out_color.w != out_color.w) out_color.w = 1.0;
	out_color.xyz = clamp(out_color.xyz, vec3(0.0), vec3(1.0));
	out_color.xyz = out_color.xyz*4.0;
	out_color2.xyz = vec3(0.0) + ex_secondary_color.xyz*fMiePhase;
	out_color2 = clamp(out_color2, 0.0, 1.0);
	out_color2.x = id;
	
	if(ex_v3Direction.z > 0.0) out_color2 = vec4(0.0, 0.0, 0.0, 1.0);
}

