#version 330 core
uniform sampler2D color_tex;
uniform float texsize;

in vec2 ex_texcoord;
out vec4 out_color;

float offset[5] = float[]( 0.0, 1.0, 2.0, 3.0, 4.0 );
float weight[5] = float[]( 0.2270270270, 0.1945945946, 0.1216216216, 0.0540540541, 0.0162162162 );

void main()
{
	out_color = texture( color_tex, ex_texcoord) * weight[0];			
	for (int i=1; i<5; i++) 
	{
		out_color += texture( color_tex, ex_texcoord+vec2(offset[i]/texsize, 0.0)) * weight[i];
		out_color += texture( color_tex, ex_texcoord-vec2(offset[i]/texsize, 0.0)) * weight[i];
	}
}