#version 330 core
uniform sampler2D color_tex;

in vec2 ex_texcoord;
out vec4 out_color;

float offset[3] = float[]( 0.0, 1.3846153846, 3.2307692308 );
float weight[3] = float[]( 0.2270270270, 0.3162162162, 0.0702702703 );

void main()
{
	out_color = texture( color_tex, ex_texcoord) * weight[0];
	for (int i=1; i<3; i++) 
	{
		out_color += texture( color_tex, ex_texcoord+vec2(0.0, offset[i]/1024.0)) * weight[i];
		out_color += texture( color_tex, ex_texcoord-vec2(0.0, offset[i]/1024.0)) * weight[i];
	}
	//out_color = vec4(1.0);
}