#version 330 compatibility
#extension GL_EXT_geometry_shader4 : enable
layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

uniform vec4 planeLBN;
uniform vec4 planeRBN;
uniform vec4 planeLTN;
uniform vec4 planeRTN;
uniform vec4 planeLBT;
uniform vec4 planeRBT;
uniform vec4 planeLTT;
uniform vec4 planeRTT;

uniform mat4 ProjectionMatrix;
uniform mat4 osg_ViewMatrix;
uniform mat4  viewMatrixInv;

uniform mat4 light_proj_matrix;
uniform mat4 light_mv_matrix;

out vec2 ex_texCoord;
out vec4 ex_shadowCoord;

void main()                                                   
{			
	vec3 pos = (gl_PositionIn[0]).xyz; // eye space
	pos.z -= 0.5;
	pos.z *= 2.0;
		
	mat4 ShadowMatrix = light_proj_matrix * light_mv_matrix;
	mat4 Transformation = gl_ProjectionMatrix * osg_ViewMatrix;
	
	vec4 worldPos = planeLBN * (1.0-pos.z) + planeLBT * pos.z;
	ex_texCoord = vec2(0.0, 0.0);					
	gl_Position = gl_ProjectionMatrix * osg_ViewMatrix * worldPos;
	ex_shadowCoord =  ShadowMatrix * worldPos;
	EmitVertex();
	
	worldPos = planeRBN * (1.0-pos.z) + planeRBT * pos.z;
	ex_texCoord = vec2(0.0, 1.0);					
	gl_Position = gl_ProjectionMatrix * osg_ViewMatrix * worldPos;
	ex_shadowCoord =  ShadowMatrix * worldPos;
	EmitVertex();

	worldPos = planeLTN * (1.0-pos.z) + planeLTT * pos.z;
	ex_texCoord = vec2(1.0, 0.0);      					
	gl_Position = gl_ProjectionMatrix * osg_ViewMatrix * worldPos;		
	ex_shadowCoord =  ShadowMatrix * worldPos;
	EmitVertex();

	worldPos = planeRTN * (1.0-pos.z) + planeRTT * pos.z;
	ex_texCoord = vec2(1.0, 1.0);			
	gl_Position = gl_ProjectionMatrix * osg_ViewMatrix * worldPos;		
	ex_shadowCoord =  ShadowMatrix * worldPos;
	EmitVertex();
	EndPrimitive();	
} 