#version 330 compatibility
#extension GL_EXT_geometry_shader4 : enable
layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

uniform mat4 ProjectionMatrix;
uniform mat4 osg_ViewMatrix;
uniform mat4  viewMatrixInv;

uniform mat4 light_proj_matrix;
uniform mat4 light_mv_matrix;

out vec2 ex_texCoord;
out vec4 ex_shadowCoord;

void main()                                                   
{			
	vec3 pos = (gl_PositionIn[0]).xyz; // eye space
	pos.z -= 0.5;
	pos.z *= 2.0;
	
	mat4 WorldMatrix = inverse(osg_ViewMatrix);
	mat4 ShadowMatrix = light_proj_matrix * light_mv_matrix * WorldMatrix;
	mat4 Transformation = gl_ProjectionMatrix * osg_ViewMatrix;
	
	vec4 worldPos = vec4(0.0, pos.z*5000.0, 5000.0,1.0);
	vec4 viewPos = osg_ViewMatrix * worldPos;
	ex_texCoord = vec2(0.0, 0.0);				
	//gl_Position = Transformation * worldPos;
	//ex_shadowCoord =  ShadowMatrix * gl_Position;
	vec4 viewPos2 = vec4(viewPos.x*-5000.0,viewPos.y*-5000.0, viewPos.z, 1.0);
	gl_Position = gl_ProjectionMatrix * viewPos2;		
	ex_shadowCoord =  ShadowMatrix * viewPos2;
	EmitVertex();
	
	     worldPos = vec4(0.0, pos.z*5000.0, 5000.0,1.0);
		 viewPos = osg_ViewMatrix * worldPos;
	ex_texCoord = vec2(0.0, 1.0);				
	//gl_Position = Transformation * worldPos;
	//ex_shadowCoord =  ShadowMatrix * worldPos;
	viewPos2 = vec4(viewPos.x*-5000.0,viewPos.y* 5000.0, viewPos.z, 1.0);
	gl_Position = gl_ProjectionMatrix * viewPos2;		
	ex_shadowCoord =  ShadowMatrix * viewPos2;
	EmitVertex();

	     worldPos = vec4( 0.0,pos.z*5000.0, 5000.0, 1.0);
		 viewPos = osg_ViewMatrix * worldPos;
	ex_texCoord = vec2(1.0, 0.0);      				
	//gl_Position = Transformation * worldPos;
	//ex_shadowCoord =  ShadowMatrix * worldPos;
	viewPos2 = vec4(viewPos.x* 5000.0,viewPos.y*-5000.0, viewPos.z, 1.0);
	gl_Position = gl_ProjectionMatrix * viewPos2;		
	ex_shadowCoord =  ShadowMatrix * viewPos2;
	EmitVertex();

	     worldPos = vec4( 0.0, pos.z*5000.0, 5000.0,1.0);
		 viewPos = osg_ViewMatrix * worldPos;
	ex_texCoord = vec2(1.0, 1.0);			
	//gl_Position =  Transformation * worldPos;
	//ex_shadowCoord =  ShadowMatrix * worldPos;
	viewPos2 = vec4(viewPos.x* 5000.0,viewPos.y* 5000.0, viewPos.z, 1.0);
	gl_Position = gl_ProjectionMatrix * viewPos2;		
	ex_shadowCoord =  ShadowMatrix * viewPos2;
	EmitVertex();
	EndPrimitive();	
} 