#version 330 core

uniform mat4 ProjectionMatrix;
uniform mat4 ViewMatrix;
uniform mat4 ModelMatrix;
uniform mat4 light_proj_matrix;
uniform mat4 light_mv_matrix;


layout (location = 0) in vec4 in_position;
layout (location = 1) in vec4 in_texCoord;
layout (location = 2) in vec4 in_normal;

out float ex_lightdistance;
out vec2 ex_texCoord;
out vec4 ex_shadowCoord;

out vec4 ambientColor;
out vec4 diffuseColor;
out vec4 specularColor;

out vec3 normalEye;
out vec3 lightDir;
out vec3 positionEye;


void main(void)
{ 
vec3 lightPosition=vec3(0.0, 0.0,  200000.0);

vec4 lightAmbientColor=vec4(0.1);
vec4 lightDiffuseColor=vec4(1.0);
vec4 lightSpecularColor=vec4(1.0);

vec4 materialAmbientColor=vec4(1.0);
vec4 materialDiffuseColor=vec4(1.0);
vec4 materialSpecularColor=vec4(1.0);
	
	ambientColor = materialAmbientColor * lightAmbientColor;
	diffuseColor = materialDiffuseColor * lightDiffuseColor;
	specularColor = materialSpecularColor * lightSpecularColor;
	

	mat4 mvpMatrix = ProjectionMatrix * ViewMatrix * ModelMatrix;
	vec4 modelViewTimesVertex = ViewMatrix * ModelMatrix * in_position;

	positionEye = modelViewTimesVertex.xyz;
	
	normalEye = normalize((ViewMatrix * ModelMatrix * vec4(in_normal.xyz, 0.0)).xyz);
	lightDir = normalize(((ViewMatrix* vec4(lightPosition, 1.0)) - (modelViewTimesVertex)).xyz);

	ex_shadowCoord = light_proj_matrix * light_mv_matrix * in_position;
	ex_texCoord = in_texCoord.xy;
	gl_Position = mvpMatrix * in_position;

	ex_lightdistance = (((vec4(lightPosition,1.0) - vec4(ModelMatrix * in_position)).z));
}
