#version 330 core
uniform sampler2D tex0;

in vec2 ex_texCoord;

in vec4 ex_shadowCoord;
in float ex_lightdistance;

in vec4 ambientColor;
in vec4 diffuseColor;
in vec4 specularColor;

in vec3 normalEye;
in vec3 lightDir;
in vec3 positionEye;

out vec4 out_color;
out vec4 out_color2;

void main(void)
{
float specular=10.0;

	vec4 color;
	vec4 texel;
	
	vec3 N = normalize(normalEye);
	vec3 E = normalize(-positionEye);
	vec3 L = normalize(lightDir);

	color = ambientColor;
	float NdotL = max(dot(N, L), 0.0);

	if (NdotL > 0.0) 
	{
		color += diffuseColor * NdotL;
		vec3 R = normalize(-reflect(L, N));
	
		float EdotR = max(dot(E, R), 0.0);
		color += specularColor * pow(EdotR, specular);
	}

    //texel = vec4(1.0);
	texel = texture(tex0, ex_texCoord)*5.0;
	out_color = texel * color;

	out_color.w = 1.0;
	out_color2 = vec4(0.0, 0.0, 0.0, 1.0);
}
