#version 330 core

uniform mat4 ProjectionMatrix;
uniform mat4 ViewMatrix;
uniform mat4 ModelMatrix;
uniform mat4 light_proj_matrix;
uniform mat4 light_mv_matrix;

// uniform shader-parameters
uniform vec3 v3LightPos;		// The direction vector to the light source
uniform vec3 v3InvWavelength;	// 1 / pow(wavelength, 4) for the red, green, and blue channels
uniform float fOuterRadius;		// The outer (atmosphere) radius
uniform float fOuterRadius2;	// fOuterRadius^2
uniform float fInnerRadius;		// The inner (planetary) radius
uniform float fInnerRadius2;	// fInnerRadius^2
uniform float fKrESun;			// Kr * ESun
uniform float fKmESun;			// Km * ESun
uniform float fKr4PI;			// Kr * 4 * PI
uniform float fKm4PI;			// Km * 4 * PI
uniform float fScale;			// 1 / (fOuterRadius - fInnerRadius)
uniform float fScaleDepth;		// The scale depth (i.e. the altitude at which the atmosphere's average density is found)
uniform float fScaleOverScaleDepth;	// fScale / fScaleDepth


layout (location = 0) in vec4 in_position;
layout (location = 1) in vec4 in_texCoord;
layout (location = 2) in vec4 in_normal;

out float ex_lightdistance;
out vec2 ex_texCoord;
out vec4 ex_shadowCoord;

out vec4 ambientColor;
out vec4 diffuseColor;
out vec4 specularColor;

out vec3 normalEye;
out vec3 lightDir;
out vec3 positionEye;

out vec4 ex_secondary_color;
out vec4 ex_front_color;
out vec3 ex_v3Direction;

const int nSamples = 10;
const float fSamples = 10.0;

float scale(float fCos)
{
	float x = 1.0 - fCos;
	return fScaleDepth * exp(-0.00287 + x*(0.459 + x*(3.83 + x*(-6.80 + x*5.25))));
}

float getNearIntersection(vec3 v3Pos, vec3 v3Ray, float fDistance2, float fRadius2)
{
   float B = 2.0 * dot(v3Pos, v3Ray);
   float C = fDistance2 - fRadius2;
   float fDet = max(0.0, B*B - 4.0 * C);
   return 0.5 * (-B - sqrt(fDet));
}

void main(void)
{ 
vec3 lightPosition=vec3(0.0, 0.0,  200000.0);

vec4 lightAmbientColor=vec4(0.1);
vec4 lightDiffuseColor=vec4(1.0);
vec4 lightSpecularColor=vec4(1.0);

vec4 materialAmbientColor=vec4(1.0);
vec4 materialDiffuseColor=vec4(1.0);
vec4 materialSpecularColor=vec4(0.5);
	
	ambientColor = materialAmbientColor * lightAmbientColor;
	diffuseColor = materialDiffuseColor * lightDiffuseColor;
	specularColor = materialSpecularColor * lightSpecularColor;
	

	mat4 mvpMatrix = ProjectionMatrix * ViewMatrix * ModelMatrix;
	vec4 modelViewTimesVertex = ViewMatrix * ModelMatrix * in_position;

	positionEye = modelViewTimesVertex.xyz;
	
	normalEye = normalize((ViewMatrix * ModelMatrix * vec4(in_normal.xyz, 0.0)).xyz);
	lightDir = normalize(((ViewMatrix* vec4(lightPosition, 1.0)) - (modelViewTimesVertex)).xyz);

	ex_shadowCoord = light_proj_matrix * light_mv_matrix * ModelMatrix *  in_position;
	ex_texCoord = in_texCoord.xy;
	gl_Position = mvpMatrix * in_position;	

	ex_lightdistance = length(((vec4(lightPosition,1.0) - vec4(ModelMatrix * in_position))));
	
	
	
	
	
	
	
	
	//Ground to space
	float InnerRadius = fInnerRadius;
	float OuterRadius = fOuterRadius;
	InnerRadius*=1.0;
	OuterRadius*=1.0;	
	float InnerRadius2=pow(InnerRadius,2.0);
	float OuterRadius2=pow(OuterRadius,2.0);
	
	vec3 v3CameraPos = (inverse(ViewMatrix) * vec4(0.0, 0.0, 0.0, 1.0)).xyz;		
	vec3 vecCamera = v3CameraPos;		
	vecCamera /= 100000.0*InnerRadius;
	vecCamera.z += InnerRadius; 
	
	float fCameraHeight = length(vecCamera);
	float fCameraHeight2 = pow(fCameraHeight, 2.f);	
	
	vec3 lightPos = normalize(v3LightPos);

	// Get the ray from the camera to the vertex, and its length (which is the far point of the ray passing through the atmosphere)
	vec3 v3Pos = (ModelMatrix*in_position).xyz;	
	v3Pos /= 100000.0*InnerRadius;	
	v3Pos.z += InnerRadius*1.1;//wenn kleiner... dann wei oben
	
	vec3 v3Ray = v3Pos - vecCamera;	
	
	float fFar = length(v3Ray);
	v3Ray /= fFar;	

	//float near = getNearIntersection(vecCamera, v3Ray, fCameraHeight2, fOuterRadius2);
	float near =  0.0; //getNearIntersection(v3Pos, v3Ray, length(v3Ray), InnerRadius2);
	
	// Calculate the ray's starting position, then calculate its scattering offset
	vec3 v3Start = vecCamera;
	float fHeight = length(v3Start);
	float fDepth;

	fDepth = exp(fScaleOverScaleDepth * (fInnerRadius - fCameraHeight));
	float fStartAngle = dot(v3Ray, v3Start) / fHeight;
	float fStartOffset = fDepth*scale(fStartAngle);	

	// Initialize the scattering loop variables
	float fSampleLength = fFar / fSamples;
	float fScaledLength = fSampleLength * fScale;
	vec3 v3SampleRay = v3Ray * fSampleLength;	
	vec3 v3SamplePoint = v3Start + (v3SampleRay * 0.5);

	// Now loop through the sample rays
	vec3 v3FrontColor = vec3(0.0);
	vec3 v3Attenuate;
	for(int i=0; i<nSamples; i++)
	{
		float fHeight = length(v3SamplePoint);													//OK
		float fDepth = exp(fScaleOverScaleDepth * (fInnerRadius - fHeight));					//OK
		
		float fLightAngle = dot(lightPos, v3SamplePoint) / fHeight;								//OK
		float fCameraAngle = dot(v3Ray, v3SamplePoint) / fHeight;								//OK
		float fScatter = (fStartOffset + fDepth*(scale(fLightAngle) - scale(fCameraAngle)));	//OK
		v3Attenuate = exp(-fScatter * (v3InvWavelength * fKr4PI + fKm4PI));						//OK		
		
		v3FrontColor += v3Attenuate * (fDepth * fScaledLength);
		v3SamplePoint += v3SampleRay;
	}

	// Finally, scale the Mie and Rayleigh colors and set up the varying variables for the pixel shader
	ex_secondary_color.rgb = v3FrontColor * fKmESun;			
	ex_secondary_color.w = 1.0;
	ex_front_color.w = 1.0;
	ex_front_color.rgb = v3FrontColor * (v3InvWavelength * fKrESun);	
	ex_v3Direction = vecCamera - v3Pos;	
}
