#version 330 core
uniform sampler2D tex0;
uniform sampler2D shadow_tex;

uniform vec3 v3LightPos;
uniform float g;
uniform float g2;


in vec2 ex_texCoord;

in vec4 ex_shadowCoord;
in float ex_lightdistance;

in vec4 ambientColor;
in vec4 diffuseColor;
in vec4 specularColor;

in vec3 normalEye;
in vec3 lightDir;
in vec3 positionEye;

in vec4 ex_secondary_color;
in vec4 ex_front_color;
in vec3 ex_v3Direction;

out vec4 out_color;
out vec4 out_color2;

float chebyshevUpperBound(vec2 moments, float distance)
{
	//moments.x*= 1.005;
	if (distance <= moments.x*1.05)	return 1.0;			
	else							return 0.0;
	
	float variance = moments.y - (moments.x*moments.x);
	//variance = max(variance,5.0);
	
	float d = distance - moments.x;
	float p_max = (variance / (variance + d*d));
	return clamp(p_max,0.0, 1.0);
}


void main(void)
{
float specular=10.0;

	vec4 ShadowCoordPostW = ex_shadowCoord;
	ShadowCoordPostW = ShadowCoordPostW / ex_shadowCoord.w;
	ShadowCoordPostW.xyz = ShadowCoordPostW.xyz * 0.5 + 0.5;	

	vec4 shadow_texture = texture(shadow_tex, ShadowCoordPostW.xy);
	vec2 moments = shadow_texture.st;
	float shadow = chebyshevUpperBound(moments, ex_lightdistance);

	vec4 color;
	vec4 texel;
	
	vec3 N = normalize(normalEye);
	vec3 E = normalize(-positionEye);
	vec3 L = normalize(lightDir);

	color = ambientColor;
	float NdotL = max(dot(N, L), 0.0);

	if (NdotL > 0.0) 
	{
		vec3 lightDir = normalize(v3LightPos);
		float fCos = dot(lightDir, ex_v3Direction) / length(ex_v3Direction);
		float fMiePhase = 1.5 * ((1.0 - g2) / (2.0 + g2)) * (1.0 + fCos*fCos) / pow(1.0 + g2 - 2.0*g*fCos, 1.5);
		vec4 mie;		
		mie = ex_front_color + ex_secondary_color*0.25;//fMiePhase;		
		mie = abs(mie);
				
		texel = texture(tex0, ex_texCoord);//*5.0;
		mie.x *= texel.x;
		mie.y *= texel.y;
		mie.z *= texel.z;		
		
		//mie = clamp(mie, 0.01, 1.0);
		color += mie * NdotL;
		vec3 R = normalize(-reflect(L, N));
	
		float EdotR = max(dot(E, R), 0.0);
		color += specularColor * pow(EdotR, specular);
	}

    //texel = vec4(1.0);
	//out_color = texel * color;	
	out_color = color;	
	
	out_color.xyz *= 1.0-clamp(vec3((1.0-shadow)*shadow_texture.w*0.85), vec3(0.0), vec3(1.0));
		
	out_color.w = 1.0;
	out_color2 = vec4(0.0, 0.0, 0.0, 1.0);
}
