#version 400 core

uniform sampler2D tex0;
uniform int id;

in vec3 p;
in vec4 ex_shadowCoord;
in vec3 n;
in vec2 uv;
in float ex_lightdistance;

in vec3 out_normal;
in vec3 lightPos;
in vec3 eyeW;
in vec3 positionW;

in vec2 ex_texCoord;

in vec4 fragC;

in vec3 ex_secondary_color;
in vec3 ex_front_color;

out vec4 out_color;
	
void main(void)
{
	vec4 ShadowCoordPostW = ex_shadowCoord;
	float depth = ShadowCoordPostW.z / ShadowCoordPostW.w;
	ShadowCoordPostW = ShadowCoordPostW / ex_shadowCoord.w;
	ShadowCoordPostW.xyz = ShadowCoordPostW.xyz * 0.5 + 0.5;	

	vec4 shadow_texture = vec4(0.0);
	float shadow = 1.0;
	if(ShadowCoordPostW.s >= 0.0 && ShadowCoordPostW.s <= 1.0 && ShadowCoordPostW.t >= 0.0 && ShadowCoordPostW.t <= 1.0)	
	{
		shadow_texture = textureLod(shadow_tex, ShadowCoordPostW.xy,2.5);
		shadow = chebyshevUpperBound(shadow_texture.st, ex_lightdistance);	
	}
		    
    vec3 reflectance; //textureTile(orthoSampler, uv).rgb * 0.2;
	vec4 layerdef = texture(tex_def , uv);
	vec4 color2= texture(tex0, uv);		
	vec4 tgrass = texture(tex_grass, uv*vec2(100.0,100.0));
	color2 += texture(tex_grass,  uv*vec2(80.0,80.0))  * (1.0-clamp(layerdef.b+layerdef.r+layerdef.g/*+layerdef.a*/, 0.0, 1.0)); 	
	//color2 += texture(bolder_tex, uv*vec2(10.0,10.0))  * layerdef.a; 
	color2 += texture(tex_rock,  uv*vec2(80.0,80.0))   * layerdef.b; 		
	color2 += tgrass * layerdef.g; 	
	color2 += texture(tex_sand,  uv*vec2(80.0,80.0))   * layerdef.r; 			
	
	
	vec4 bump4 = texture(bump4_tex, ex_texCoord.xy*vec2(100,100));
	vec4 bump6 = texture(bump6_tex, ex_texCoord.xy*vec2(100,100));
	bump4.xyz = 2.0*bump4.xyz-1.0;
	bump6.xyz = 2.0*bump6.xyz-1.0;
	
	vec3 N = bump4.xyz;		
	N	= mix(bump6.xyz, N, 1.0-layerdef.b);			
	N = normalize(N);
	
	//vec3 out_normal = Normal;
	mat3 normal_rotation_matrix;
	normal_rotation_matrix[2]= out_normal;
	normal_rotation_matrix[1]=normalize(cross(vec3(-1.0,0.0,0.0), out_normal));
	normal_rotation_matrix[0]=normalize(cross(normal_rotation_matrix[2],normal_rotation_matrix[1]));
	N= normalize(normal_rotation_matrix * N);	
	
	vec2 texCoord = gl_FragCoord.st / vec2(800.0, 600.0);	

	
	vec3 E = normalize(eyeW-positionW);
	vec3 L = normalize(lightPos-positionW);	
		
	//color2.xyz = vec3(1.0);
	vec4 color = vec4(0.0,0.0,0.0,1.0);	
	float NdotL = max(dot(N, L), 0.0);
	if (NdotL > 0.0) 
	{			
		color += color2 * NdotL;
		vec3 R = normalize(reflect(L, N));
	
		float EdotR = max(dot(normalize(-E).xyz, R), 0.0);
		//color += vec4(1.0) * pow(EdotR, 10.0);
	}			
		
	vec3 mie = clamp(ex_front_color + (ex_secondary_color*1.0), vec3(0.0), vec3(1.0));			
	color.xyz = mix(vec3(1.0)*mie, color.xyz, exp(-1.0*pow(length(eyeW-positionW)/pow(pow(10000.0,2.0)*3.0,0.5),2.0)));	
		
	out_color.xyz = color.xyz;		
	out_color.xyz *= vec3(clamp(shadow, 0.1, 1.0));										 	
	out_color.xyz*=3.0;

	out_color.w = 1.0;
	out_color2 = vec4(id, 0.0, 0.0, 1.0);
}
