#version 330 compatibility 
uniform sampler2D tex0;
uniform sampler2D shadow_tex;
uniform sampler2D shadow_tex2;
uniform sampler2D tex_def;

uniform sampler2D tex_sand;
uniform sampler2D tex_rock;
uniform sampler2D tex_grass;

uniform sampler2D bump4_tex;
uniform sampler2D bump6_tex;

uniform vec3 v3LightPos;
uniform float g;
uniform float g2;

uniform int id;

in vec2 ex_texCoord;

in vec4 ex_shadowCoord;
in float ex_lightdistance;

in vec4 ambientColor;
in vec4 diffuseColor;
in vec4 specularColor;

in vec3 normalEye;
in vec3 lightDir;
in vec3 positionEye;

in vec4 ex_secondary_color;
in vec4 ex_front_color;
in vec3 ex_v3Direction;

out vec4 out_color;
out vec4 out_color2;

in vec3 lightVec;
in vec3 eyeVec;

// Calculates the Mie phase function
float getMiePhase(float fCos, float fCos2, float g, float g2)
{
	return 1.5 * ((1.0 - g2) / (2.0 + g2)) * (1.0 + fCos2) / pow(1.0 + g2 - 2.0*g*fCos, 1.5);
}

// Calculates the Rayleigh phase function
float getRayleighPhase(float fCos2)
{
	//return 1.0;
	return 0.75 + 0.75*fCos2;
}

float chebyshevUpperBound(vec2 moments, float distance)
{	
	if (distance <= moments.x)	return 1.0;				
	
	float variance = moments.y - (moments.x*moments.x);
	variance = clamp(variance,-5000.0, 5000.0);
	
	float d = distance - moments.x;
	float p_max = (variance / (variance + d*d));
	float min1 = 0.1;
	float max1 = 1.0;
	p_max = clamp((p_max-min1)/(max1-min1), 0.0, 1.0);	
	return p_max;	
}


void main(void)
{
	float specular=10.0;

	vec4 ShadowCoordPostW = ex_shadowCoord;
	ShadowCoordPostW.xy = ShadowCoordPostW.xy / ex_shadowCoord.w;
	ShadowCoordPostW.xy = ShadowCoordPostW.xy * 0.5 + 0.5;	
		
	vec4 shadow_texture = texture(shadow_tex, ShadowCoordPostW.xy);	
	float shadow = chebyshevUpperBound(shadow_texture.xy, ShadowCoordPostW.z);	
	
	vec4 shadow_texture2 = texture(shadow_tex2, ShadowCoordPostW.xy);
	float shadow2 = chebyshevUpperBound(shadow_texture2.xy, ShadowCoordPostW.z);	
	
	if(ShadowCoordPostW.s < 0.0 || ShadowCoordPostW.t < 0.0 || ShadowCoordPostW.s > 1.0 || ShadowCoordPostW.t > 1.0)
		shadow = 1.0;


//_____ PARALLAX MAPPING __________	
	float scale = 0.01;

	vec3 E = normalize(eyeVec);
	vec3 L = normalize(lightVec);
	
	float height = (scale * length(texture(bump6_tex, ex_texCoord*vec2(20.0,20.0)).w)) - (scale * 0.5);
	vec2 nextTexCoord = (height * E.xy) + ex_texCoord.st;
	
	//Normalmap are converted as following:
	//normalmap(x,y,z) = (x,y,z)/2.0 + 0.5  
	vec3 N = texture(bump4_tex, ex_texCoord*vec2(20.0,20.0)).xyz*vec3(2.0)-vec3(1.0);
	N.xyz = normalize(N.xzy); //MIT DEM SCHAUT ES VIEL BESSER AUS...
		
	vec4 color;
	vec4 texel;	
		
	float NdotL = clamp(dot(N, L), 0.0, 1.0);
//___________________
	
	texel = texture(tex0, ex_texCoord*vec2(20.0,20.0));
	vec4 layerdef = texture(tex_def , ex_texCoord);
	vec4 color2= vec4(0.0);//texel;	
	color2 += texture(tex_rock,  ex_texCoord*vec2(20.0,20.0)) * pow(layerdef.b,2.0); 
	color2 += texture(tex_grass, ex_texCoord*vec2(20.0,20.0)) * layerdef.g; 	
	color2 += texture(tex_sand,  ex_texCoord*vec2(20.0,20.0)) * pow(layerdef.r,2.0); 
	
	float fCos = dot(lightDir, ex_v3Direction) / length(ex_v3Direction);
	float fCos2 = fCos*fCos;
	float fMiePhase = 1.5 * ((1.0 - g2) / (2.0 + g2)) * (1.0 + fCos*fCos) / pow(1.0 + g2 - 2.0*g*fCos, 1.5);
	vec4  mie  = ex_front_color *0.8 + 0.85 *color2 * ex_secondary_color;		
	//mie = mie*0.8 + color2*0.2;
	
	mie = clamp(mie, 0.0, 1.0);		
	color = mie*0.41+vec4(0.01);	

	if (NdotL > 0.0) 
	{
		vec3 lightDir = normalize(v3LightPos);						
		
		color += mie * NdotL*0.9;
		//color += color2 * NdotL * 0.6;		
		vec3 R = normalize(-reflect(L, N));
	
		float EdotR = max(dot(E, R), 0.0);
		color += specularColor * pow(EdotR, 10.1);
	}
    	
	out_color = color;			
	out_color.xyz *= shadow2;
	out_color.xyz *= 1.0-clamp(shadow_texture.z*2.0,0.0,1.0);
		
	out_color.w = 1.0;	
	//out_color.xyz = mie.xyz;
	out_color.xyz = clamp(out_color.xyz*1.75, vec3(0.0), vec3(10.0));
	out_color.w = 1.0;//log(1.0+out_color.x *0.2126 + out_color.y * 0.7152 + out_color.z * 0.0722);
	out_color2 = vec4(id, 0.0, 0.0, 1.0);
}
