#version 330 core
uniform sampler2D tex0;
uniform sampler2D shadow_tex;
uniform samplerCube cube_tex;

in vec2 ex_texCoord;

in vec4 ex_shadowCoord;
in float ex_lightdistance;

in vec4 ambientColor;
in vec4 diffuseColor;
in vec4 specularColor;

in vec3 normalEye;
in vec3 lightDir;
in vec3 positionEye;

in vec3 ex_secondary_color;
in vec3 ex_front_color;
in vec3 ex_v3Direction;

uniform vec3 v3LightPos;
uniform float g;
uniform float g2;

uniform int id;

out vec4 out_color;
out vec4 out_color2;

// Calculates the Mie phase function
float getMiePhase(float fCos, float fCos2, float g, float g2)
{
	return 1.5 * ((1.0 - g2) / (2.0 + g2)) * (1.0 + fCos2) / pow(1.0 + g2 - 2.0*g*fCos, 1.5);
}

// Calculates the Rayleigh phase function
float getRayleighPhase(float fCos2)
{
	//return 1.0;
	return 0.75 + 0.75*fCos2;
}

float chebyshevUpperBound(vec2 moments, float distance)
{
	//moments.x*= 1.005;
	if (distance <= moments.x*1.05)	return 1.0;			
	else							return 0.0;
	
	float variance = moments.y - (moments.x*moments.x);
	//variance = max(variance,5.0);
	
	float d = distance - moments.x;
	float p_max = (variance / (variance + d*d));
	return clamp(p_max,0.0, 1.0);
}


void main(void)
{
float specular=2.0;

	vec4 ShadowCoordPostW = ex_shadowCoord;
	ShadowCoordPostW = ShadowCoordPostW / ShadowCoordPostW.w;
	ShadowCoordPostW.xyz *= vec3(0.5);
	ShadowCoordPostW.xyz += vec3(0.5);
	vec4 shadow_texture = texture(shadow_tex, ShadowCoordPostW.xy);
	
	vec2 moments = shadow_texture.st;
	float shadow = chebyshevUpperBound(moments, ex_lightdistance);

	vec4 color;
	vec4 texel;
	
	vec3 N = normalize(normalEye);
	vec3 E = normalize(positionEye);
	vec3 L = normalize(lightDir);

	float NdotL = max(dot(N, L), 0.0);

	vec3 R = normalize(reflect(-positionEye, N));	
	
	vec4 reflex_tex = texture(cube_tex, R);
	//reflex_tex = vec4(1.0);
	color.xyz = reflex_tex.xyz*3.1;
	color.w = 1.0;
	
	
	
	float EdotR = max(dot(E, R), 0.0);

	float fCos = dot(lightDir, ex_v3Direction) / length(ex_v3Direction);
	float fCos2 = fCos*fCos;
	float fMiePhase = 1.5 * ((1.0 - g2) / (2.0 + g2)) * (1.0 + fCos2) / pow(1.0 + g2 - 2.0*g*fCos, 1.5);
	
	texel = texture(tex0, ex_texCoord);	
	vec3  mie  = ex_front_color  + 0.85 *texel.xyz * ex_secondary_color;	;//fMiePhase * ex_secondary_color;			
	mie = clamp(mie, vec3(0.0), vec3(1.0));
	
	color.xyz = mie.xyz*0.01;		
	if (NdotL > 0.0) 
	{
		color.xyz += texel.xyz * 1.9 * NdotL;				
		color.xyz += vec3(8.0) * clamp(pow(EdotR, specular), 0.0, 1.0);
		
		//color *= dot(E, N);	
	}			
	
	//color.xyz *= mie;
	//color = mix(reflex_tex, color, max(0.0, 1.0-0.5 * max(0.0, dot(E, N))));		

	out_color = texel * color;		

//	out_color = color;
	
	//out_color.xyz = mie.xyz;	
	out_color.xyz *= 1.5;		
		
	
	//out_color.xyz *= min(vec3(clamp(clamp(1.0-(shadow_texture.z),0.0,1.0), 0.0, 1.0)), vec3(clamp((shadow), 0.0, 1.0)))+0.1;				
	//out_color = vec4(5.0, 5.0, 5.0, 1.0);		
	
	out_color.xyz *= 1.0-shadow_texture.z;
	out_color.xyz = clamp(out_color.xyz, vec3(0.0), vec3(10.0));	
	out_color.w = 1.0;		
	out_color2 = vec4(float(id), 0.0, 0.0, 1.0);
}
