#version 330 core

// uniform shader-parameters
uniform sampler2D color_tex;
uniform sampler2D ls_tex;
uniform sampler2D color_cloud_tex;
uniform sampler2D debug_tex;

uniform mat4 ModelViewMatrix;
uniform mat4 ViewMatrix;
uniform mat4 ProjectionMatrix;
uniform vec3 un_lightPos;
uniform float weight;
uniform float exposure;
uniform float density;
uniform float decay;

uniform int un_width;
uniform int un_height;

// fragment-shader output variable (-> stored in the frame-buffer, i.e. "the pixel you see")
out vec4 out_color;
out vec4 out_color2;

void main()
{   			
	mat4 viewmatrix = ViewMatrix;
	viewmatrix[3][0] = 0.0;
	//viewmatrix[3][1] -= 0.0;
	viewmatrix[3][2] = 0.0;
	
	mat4 viewProjection = ProjectionMatrix * viewmatrix;

	vec2 texCoord = gl_FragCoord.st / vec2(float(un_width), float(un_height));	
	vec4 tex_color = texture(color_tex, texCoord);	
	
			
	vec4 cloud = texture(color_cloud_tex,texCoord);	
	//cloud = vec4(0.0);
	vec4 tex_color2 = vec4(0.0);
	tex_color2 = tex_color*(1.0-cloud.w) + cloud;					
	tex_color2.w = 1.0;
	
	out_color.xyz = tex_color2.xyz*0.9;
	out_color.w = log(0.001 + out_color.x *0.2126 + out_color.y * 0.7152 + out_color.z * 0.0722);
	
	vec3 lightDir = normalize(un_lightPos);	
	//lightDir.xy *= -1.0;
	vec4 l = viewProjection * vec4(lightDir.xyz, 0.0);
	
	l.xyz /= l.w;
	l.xyz *= 0.5;
	l.xyz += 0.5;	

	vec4 lightPos = l;	

	out_color2 = vec4(0.0);
	
	vec2 TextureCoord = texCoord;		
	vec4 color = texture(ls_tex, TextureCoord);	
	vec4 color_cpy = color;
	color = vec4(color.y);
	if(lightPos.x >= -0.1 && lightPos.x <= 1.1 && lightPos.y >= -0.1 && lightPos.y <= 1.1 && false)
	{		
		vec2 dTextureCoord = vec2( TextureCoord - lightPos.xy);
		dTextureCoord *= density / 20.0;
		float illuminationDecay = 1.0; 
		for(int i=0; i < 20; i++)
		{
			TextureCoord -= dTextureCoord;
			vec4 sample = vec4(texture(ls_tex, TextureCoord).z);
			color += vec4(sample.y * illuminationDecay * weight);
			illuminationDecay *= decay;  
		}
		out_color.xyz += color.xyz;	
	}	
	
	//out_color.xyz = texture(debug_tex, texCoord).xyz;		
	//out_color.w = log(0.001 + out_color.x *0.2126 + out_color.y * 0.7152 + out_color.z * 0.0722);
	
	out_color2.xyz = tex_color2.xyz;
	if(length(tex_color2.xyz) > 8.0) 	out_color2 = vec4(color_cpy.x, 1.0, 1.0, 1.0);
	else								out_color2 = vec4(color_cpy.x, 0.0, 0.0, 0.0);
}