#version 400 core
#extension GL_EXT_geometry_shader4 : enable
layout (triangles) in;
layout (triangle_strip, max_vertices = 8) out;

uniform sampler2D tex_def;

uniform mat4 ProjectionMatrix;
uniform mat4 ViewMatrix;
uniform mat4  viewMatrixInv;
uniform vec3 un_light_pos;

uniform mat4 viewHalfAngleMatrix;
uniform mat4 invViewHalfAngleMatrix;	

uniform mat4 project_light;
uniform mat4 viewMatrix_light;
uniform mat4 light_mv_matrix;

in vec2 ex_vd_texCoord[];

out vec2 ex_texCoord;
out vec4 ex_position;
out vec3 p;
out float ex_lightdistance;

void main()                                                   
{			
	vec4 def = texture(tex_def, ex_vd_texCoord[0].xy);	
	if(def.y <= 0.5) return;

	vec4 lightPosition= (inverse(light_mv_matrix) * vec4(0.0,0.0,0.0,1.0));

	vec3 pos = (gl_PositionIn[0]).xyz; // eye space

	// rotation
	vec2 s = vec2(1.0, 1.0);
	float tx = 50.0;
	float ty = 50.0;
	float tz = 160.0;
		
	vec4 v1 = vec4(pos.x-tx, pos.y, pos.z, 1.0);
	vec4 v2 = vec4(pos.x-tx, pos.y, pos.z+tz, 1.0);
	vec4 v3 = vec4(pos.x+tx, pos.y, pos.z, 1.0);
	vec4 v4 = vec4(pos.x+tx, pos.y, pos.z+tz, 1.0);
	
	vec4 v5 = vec4(pos.x, pos.y-tx, pos.z, 1.0);
	vec4 v6 = vec4(pos.x, pos.y-tx, pos.z+tz, 1.0);
	vec4 v7 = vec4(pos.x, pos.y+tx, pos.z, 1.0);
	vec4 v8 = vec4(pos.x, pos.y+tx, pos.z+tz, 1.0);
	
	mat4 transformation = ProjectionMatrix*ViewMatrix;
		
	vec3 front_color;
	vec3 secondary_color;
	vec3 v3Direction;	
	vec4 pw = vec4(1.0);
	
	pw = v1;
	ex_texCoord = vec2(0.0, 0.0);			
	ex_position = pw;
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	EmitVertex();
	
	pw = v2;
	ex_texCoord = vec2(0.0, 1.0);		
	ex_position = pw;	
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	EmitVertex();

	pw = v3;
	ex_texCoord = vec2(1.0, 0.0);      			
	ex_position = pw;	
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	EmitVertex();

	pw = v4;
	ex_texCoord = vec2(1.0, 1.0);	
	ex_position = pw;		
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position =  transformation * pw;
	EmitVertex();
	EndPrimitive();
	
	pw = v5;
	ex_texCoord = vec2(0.0, 0.0);
	ex_position = pw;
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	EmitVertex();
	
	pw = v6;
	ex_texCoord = vec2(0.0, 1.0);
	ex_position = pw;	
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	EmitVertex();

	pw = v7;
	ex_texCoord = vec2(1.0, 0.0);
	ex_position = pw;	
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	EmitVertex();

	pw = v8;
	ex_texCoord = vec2(1.0, 1.0);
	ex_position = pw;		
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position =  transformation * pw;
	EmitVertex();
}  