#version 400 core
#extension GL_EXT_geometry_shader4 : enable
layout (triangles) in;
layout (triangle_strip, max_vertices = 16) out;

uniform sampler2D tex_def;

uniform mat4 ProjectionMatrix;
uniform mat4 ViewMatrix;
uniform mat4  viewMatrixInv;
uniform vec3 un_light_pos;

uniform mat4 viewHalfAngleMatrix;
uniform mat4 invViewHalfAngleMatrix;	

uniform mat4 project_light;
uniform mat4 viewMatrix_light;
uniform mat4 light_mv_matrix;

in vec2 ex_vd_texCoord[];
in vec3 ex_vd_normal[];

out vec2 ex_texCoord;
out vec4 ex_position;
out vec3 p;
out float ex_lightdistance;
out float ex_opacity;

out vec3 lightPos;
out vec3 eyeW;
out vec3 positionW;
out vec3 out_normal;


void main()                                                   
{			
	vec4 gEyeWorldPos = inverse(ViewMatrix)*vec4(0.0,0.0,0.0,1.0);
	vec3 pos = gl_PositionIn[0].xyz;//(gl_PositionIn[0]+gl_PositionIn[1]+gl_PositionIn[2]).xyz/3.0; // eye space

	vec2 texc = ex_vd_texCoord[0].xy; // (ex_vd_texCoord[0].xy+ex_vd_texCoord[1].xy+ex_vd_texCoord[2].xy)/3.0
	vec4 def = texture(tex_def, texc);	
	if((def.y <= 0.8 && (1.0f-def.x-def.y-def.z) <= 0.0) || distance(gEyeWorldPos.xyz,pos) >= 3500.0) 
	{
		for(int i = 0; i < 8; i++)
		{
			gl_Position = vec4(0.0);
			EmitVertex();
		}
		return;
	}

	vec4 lightPosition= (inverse(light_mv_matrix) * vec4(0.0,0.0,0.0,1.0));

	vec3 norm = ex_vd_normal[0].xzy;	
	vec3 dir = normalize((gl_PositionIn[1].xyz+gl_PositionIn[2].xyz)-gl_PositionIn[0].xyz);

	if(dot(norm,vec3(0.0,0.0,1.0)) < 0.0) norm*=-1.0;
	
	mat4 lookat;
	lookat[0].xyz = dir;
	lookat[1].xyz = normalize(cross(dir,norm));
	lookat[2].xyz = norm;
	lookat[3] = vec4(0.0, 0.0, 0.0, 1.0);
	
	vec3 bin = normalize(cross(dir,norm));
	/*norm = vec3(0.0,0.0,1.0);
	dir = vec3(1.0,0.0,0.0);
	bin = vec3(0.0,1.0,0.0);
	norm*=100.0;
	dir*=100.0;	
	bin*=100.0;*/
	
	// rotation
	vec2 s = vec2(1.0, 1.0);
	float tx = 10.0;
	float ty = 10.0;
	float tz = 10.0;
		
	vec4 v1 = vec4(-dir.x, -dir.y, -dir.z, 1.0);
	vec4 v2 = vec4(-dir.x+norm.x, -dir.y+norm.y, -dir.z+norm.z, 1.0);
	vec4 v3 = vec4(dir.x, dir.y, dir.z, 1.0);
	vec4 v4 = vec4(dir.x+norm.x, dir.y+norm.y, dir.z+norm.z, 1.0);
	v1.xyz *= 20.0;
	v2.xyz *= 20.0;
	v3.xyz *= 20.0;
	v4.xyz *= 20.0;
	
	float phi = 0.0*3.147/180.0;
	mat4 rotation;
	rotation[0]	= vec4(cos(phi), -sin(phi), 0.0, 0.0);
	rotation[1] = vec4(sin(phi),  cos(phi), 0.0, 0.0);
	rotation[2] = vec4(0.0,			0.0,	1.0, 0.0);
	rotation[3] = vec4(0.0,			0.0,	0.0, 1.0);
	
	
	rotation = inverse(lookat);//*rotation*inverse(lookat);
	vec4 v5 = vec4(-dir.x, -dir.y, -dir.z, 1.0);
	vec4 v6 = vec4(-dir.x+norm.x, -dir.y+norm.y, -dir.z+norm.z, 1.0);
	vec4 v7 = vec4(dir.x, dir.y, dir.z, 1.0);
	vec4 v8 = vec4(dir.x+norm.x, dir.y+norm.y, dir.z+norm.z, 1.0);	
	v5.xyz = -(dir.xyz+bin.xyz)/2.0;
	v6.xyz = -(dir.xyz+bin.xyz)/2.0 + norm.xyz;
	v7.xyz =  (dir.xyz+bin.xyz)/2.0;
	v8.xyz =  (dir.xyz+bin.xyz)/2.0 + norm.xyz;
	v5.xyz *= 20.0;
	v6.xyz *= 20.0;
	v7.xyz *= 20.0;
	v8.xyz *= 20.0;
	
	/*/vec4 v5 = rotation * v1;
	vec4 v6 = rotation * v2;
	vec4 v7 = rotation * v3;
	vec4 v8 = rotation * v4;*/
	
	phi = 135.0*3.14/180.0;
	rotation[0]	= vec4(cos(phi), -sin(phi), 0.0, 0.0);
	rotation[1] = vec4(sin(phi),  cos(phi), 0.0, 0.0);
	rotation[2] = vec4(0.0,			0.0,	1.0, 0.0);
	rotation[3] = vec4(0.0,			0.0,	0.0, 1.0);
	
	rotation = lookat;//*rotation*inverse(lookat);
	vec4 v9  = rotation * vec4(-dir.x, -dir.y, -dir.z, 1.0) 						;
	vec4 v10 = rotation * vec4(-dir.x+norm.x, -dir.y+norm.y, -dir.z+norm.z,  1.0) 	;
	vec4 v11 = rotation * vec4(dir.x, dir.y, dir.z,  1.0) 							;
	vec4 v12 = rotation * vec4(dir.x+norm.x, dir.y+norm.y, dir.z+norm.z,  1.0) 		;
	v9.xyz = -(dir.xyz-bin.xyz)/2.0;
	v10.xyz = -(dir.xyz-bin.xyz)/2.0 + norm.xyz;
	v11.xyz =  (dir.xyz-bin.xyz)/2.0;
	v12.xyz =  (dir.xyz-bin.xyz)/2.0 + norm.xyz;
	v9.xyz *=  20.0;
	v10.xyz *= 20.0;
	v11.xyz *= 20.0;
	v12.xyz *= 20.0;
	
	//rotation = transpose(rotation);
	mat4 transformation = ProjectionMatrix*ViewMatrix;
		
	vec3 front_color;
	vec3 secondary_color;
	vec3 v3Direction;	
	vec4 pw = vec4(1.0);
	
	float opacity = 1.0;
	if(distance(gEyeWorldPos.xyz,pos) >= 2000.0)
		opacity = (distance(gEyeWorldPos.xyz,pos)-2000.0) / 2000.0;
	
	pw = v1+vec4(pos.x, pos.y, pos.z, 0.0);
	ex_texCoord = vec2(0.0, 0.0);			
	ex_position = pw;
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	ex_opacity = opacity;
	eyeW = vec3(inverse(ViewMatrix)*vec4(0.0,0.0,0.0,1.0)).xyz;	
	lightPos = (inverse(light_mv_matrix) * vec4(0.0,0.0,0.0,1.0)).xyz;	
	positionW = pw.xyz;			
	out_normal = ex_vd_normal[0].xyz;;
	EmitVertex();
	
	pw = v2+vec4(pos.x, pos.y, pos.z, 0.0);
	ex_texCoord = vec2(0.0, 1.0);		
	ex_position = pw;	
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	ex_opacity = opacity;
	eyeW = vec3(inverse(ViewMatrix)*vec4(0.0,0.0,0.0,1.0)).xyz;	
	lightPos = (inverse(light_mv_matrix) * vec4(0.0,0.0,0.0,1.0)).xyz;	
	positionW = pw.xyz;			
	out_normal = ex_vd_normal[0].xyz;;
	EmitVertex();

	pw = v3+vec4(pos.x, pos.y, pos.z, 0.0);
	ex_texCoord = vec2(1.0, 0.0);      			
	ex_position = pw;	
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	ex_opacity = opacity;
	eyeW = vec3(inverse(ViewMatrix)*vec4(0.0,0.0,0.0,1.0)).xyz;	
	lightPos = (inverse(light_mv_matrix) * vec4(0.0,0.0,0.0,1.0)).xyz;	
	positionW = pw.xyz;			
	out_normal = ex_vd_normal[0].xyz;;
	EmitVertex();

	pw = v4+vec4(pos.x, pos.y, pos.z, 0.0);
	ex_texCoord = vec2(1.0, 1.0);	
	ex_position = pw;		
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position =  transformation * pw;
	ex_opacity = opacity;
	eyeW = vec3(inverse(ViewMatrix)*vec4(0.0,0.0,0.0,1.0)).xyz;	
	lightPos = (inverse(light_mv_matrix) * vec4(0.0,0.0,0.0,1.0)).xyz;	
	positionW = pw.xyz;			
	out_normal = ex_vd_normal[0].xyz;;
	EmitVertex();
	EndPrimitive();
	
	pw = v5+vec4(pos.x, pos.y, pos.z, 0.0);
	ex_texCoord = vec2(0.0, 0.0);
	ex_position = pw;
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	ex_opacity = opacity;
	eyeW = vec3(inverse(ViewMatrix)*vec4(0.0,0.0,0.0,1.0)).xyz;	
	lightPos = (inverse(light_mv_matrix) * vec4(0.0,0.0,0.0,1.0)).xyz;	
	positionW = pw.xyz;			
	out_normal = ex_vd_normal[0].xyz;;
	EmitVertex();
	
	pw = v6+vec4(pos.x, pos.y, pos.z, 0.0);
	ex_texCoord = vec2(0.0, 1.0);
	ex_position = pw;	
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	ex_opacity = opacity;
	eyeW = vec3(inverse(ViewMatrix)*vec4(0.0,0.0,0.0,1.0)).xyz;	
	lightPos = (inverse(light_mv_matrix) * vec4(0.0,0.0,0.0,1.0)).xyz;	
	positionW = pw.xyz;			
	out_normal = ex_vd_normal[0].xyz;;
	EmitVertex();

	pw = v7+vec4(pos.x, pos.y, pos.z, 0.0);
	ex_texCoord = vec2(1.0, 0.0);
	ex_position = pw;	
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	ex_opacity = opacity;
	eyeW = vec3(inverse(ViewMatrix)*vec4(0.0,0.0,0.0,1.0)).xyz;	
	lightPos = (inverse(light_mv_matrix) * vec4(0.0,0.0,0.0,1.0)).xyz;	
	positionW = pw.xyz;			
	out_normal = ex_vd_normal[0].xyz;;
	EmitVertex();

	pw = v8+vec4(pos.x, pos.y, pos.z, 0.0);
	ex_texCoord = vec2(1.0, 1.0);
	ex_position = pw;		
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position =  transformation * pw;
	ex_opacity = opacity;
	eyeW = vec3(inverse(ViewMatrix)*vec4(0.0,0.0,0.0,1.0)).xyz;	
	lightPos = (inverse(light_mv_matrix) * vec4(0.0,0.0,0.0,1.0)).xyz;	
	positionW = pw.xyz;			
	out_normal = ex_vd_normal[0].xyz;;
	EmitVertex();
	EndPrimitive();
	
	pw = v9+vec4(pos.x, pos.y, pos.z, 0.0);
	ex_texCoord = vec2(0.0, 0.0);			
	ex_position = pw;
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	ex_opacity = opacity;
	eyeW = vec3(inverse(ViewMatrix)*vec4(0.0,0.0,0.0,1.0)).xyz;	
	lightPos = (inverse(light_mv_matrix) * vec4(0.0,0.0,0.0,1.0)).xyz;	
	positionW = pw.xyz;			
	out_normal = ex_vd_normal[0].xyz;;
	EmitVertex();
	
	pw = v10+vec4(pos.x, pos.y, pos.z, 0.0);
	ex_texCoord = vec2(0.0, 1.0);		
	ex_position = pw;	
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	ex_opacity = opacity;
	eyeW = vec3(inverse(ViewMatrix)*vec4(0.0,0.0,0.0,1.0)).xyz;	
	lightPos = (inverse(light_mv_matrix) * vec4(0.0,0.0,0.0,1.0)).xyz;	
	positionW = pw.xyz;			
	out_normal = ex_vd_normal[0].xyz;;
	EmitVertex();

	pw = v11+vec4(pos.x, pos.y, pos.z, 0.0);
	ex_texCoord = vec2(1.0, 0.0);      			
	ex_position = pw;	
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position = transformation * pw;
	ex_opacity = opacity;	
	eyeW = vec3(inverse(ViewMatrix)*vec4(0.0,0.0,0.0,1.0)).xyz;	
	lightPos = (inverse(light_mv_matrix) * vec4(0.0,0.0,0.0,1.0)).xyz;	
	positionW = pw.xyz;				
	out_normal = ex_vd_normal[0].xyz;;
	EmitVertex();

	pw = v12+vec4(pos.x, pos.y, pos.z, 0.0);
	ex_texCoord = vec2(1.0, 1.0);	
	ex_position = pw;		
	p = pw.xyz;
	p.z=0.0;
	ex_lightdistance = length((lightPosition.xyz - pw.xyz).xyz);
	gl_Position =  transformation * pw;
	ex_opacity = opacity;	
	eyeW = vec3(inverse(ViewMatrix)*vec4(0.0,0.0,0.0,1.0)).xyz;	
	lightPos = (inverse(light_mv_matrix) * vec4(0.0,0.0,0.0,1.0)).xyz;	
	positionW = pw.xyz;				
	out_normal = ex_vd_normal[0].xyz;;
	EmitVertex();
	EndPrimitive();
}  