#version 330 core
#extension GL_EXT_geometry_shader4 : enable
layout (location = 0) in vec4 in_position;
layout (location = 1) in vec4 in_additional;

uniform mat4  viewMatrixInv;
uniform mat4  viewMatrix;
uniform vec3 un_light_pos;

uniform vec3 v3InvWavelength;	// 1 / pow(wavelength, 4) for the red, green, and blue channels
uniform float fOuterRadius;		// The outer (atmosphere) radius
uniform float fOuterRadius2;	// fOuterRadius^2
uniform float fInnerRadius;		// The inner (planetary) radius
uniform float fInnerRadius2;	// fInnerRadius^2
uniform float fKrESun;			// Kr * ESun
uniform float fKmESun;			// Km * ESun
uniform float fKr4PI;			// Kr * 4 * PI
uniform float fKm4PI;			// Km * 4 * PI
uniform float fScale;			// 1 / (fOuterRadius - fInnerRadius)
uniform float fScaleDepth;		// The scale depth (i.e. the altitude at which the atmosphere's average density is found)
uniform float fScaleOverScaleDepth;	// fScale / fScaleDepth

uniform float g;
uniform float g2;

out vec4 ex_vd_additional;
out vec4 ex_vd_color;

const int nSamples = 8;
const float fSamples = 8.0;

/*
vec3 CalcMie(vec3 front_color, vec3 secondary_color, vec3 v3Direction )
{
	vec3 lightDir = normalize(un_light_pos);

	float fCos = dot(lightDir, v3Direction) / length(v3Direction);
	float fMiePhase = 1.5 * ((1.0 - g2) / (2.0 + g2)) * (1.0 + fCos*fCos) / pow(1.0 + g2 - 2.0*g*fCos, 1.5);
	vec3 color = front_color + secondary_color*fMiePhase;	
	
	//color = vec4(1.0) - clamp(exp(color*-1.0),0.1,1.0);
	
	return color;	
}


float scale(float fCos)
{
	float x = 1.0 - fCos;
	return fScaleDepth * exp(-0.00287 + x*(0.459 + x*(3.83 + x*(-6.80 + x*5.25))));
}

void CalcSunColors(in vec4 vertex, out vec3 secondary_color, out vec3 front_color, out vec3 v3Direction)
{
	vec3 v3CameraPos = (viewMatrixInv * vec4(0.0, 0.0, 0.0, 1.0)).xyz;
	//vec3 v3CameraPos = vec3(0.0, 0.0, 0.0);

	vec3 vecCamera = v3CameraPos;
	vecCamera /= 10000.0*fInnerRadius;
	vecCamera.z += fInnerRadius;
	
	float fCameraHeight = length(vecCamera);
	float fCameraHeight2 = pow(fCameraHeight, 2.f);	
		
	vec3 lightPos = normalize(un_light_pos);

	// Get the ray from the camera to the vertex, and its length (which is the far point of the ray passing through the atmosphere)
	vec3 v3Pos = vertex.xyz/10000.0*fInnerRadius; //HACK 50000 gehrt eigentlich
	v3Pos.z += fInnerRadius;
	vec3 v3Ray = v3Pos - vecCamera;
	float fFar = length(v3Ray);
	v3Ray /= fFar;

	// Calculate the ray's starting position, then calculate its scattering offset
	vec3 v3Start = vecCamera;
	float fHeight = length(v3Start);
	float fDepth = exp(fScaleOverScaleDepth * (fInnerRadius - fCameraHeight));
	float fStartAngle = dot(v3Ray, v3Start) / fHeight;
	float fStartOffset = fDepth*scale(fStartAngle);

	// Initialize the scattering loop variables
	float fSampleLength = fFar / fSamples;
	float fScaledLength = fSampleLength * fScale;
	vec3 v3SampleRay = v3Ray * fSampleLength;
	vec3 v3SamplePoint = v3Start + (v3SampleRay * vec3(0.5));

	// Now loop through the sample rays
	vec3 v3FrontColor = vec3(0.0);
	for(int i=0; i<nSamples; i++)
	{
		float fHeight = length(v3SamplePoint);
		float fDepth = exp(fScaleOverScaleDepth * (fInnerRadius - fHeight));
		float fLightAngle = dot(lightPos, v3SamplePoint) / fHeight;
		float fCameraAngle = dot(v3Ray, v3SamplePoint) / fHeight;
		float fScatter = (fStartOffset + fDepth*(scale(fLightAngle) - scale(fCameraAngle)));
		vec3 v3Attenuate = exp(-fScatter * (v3InvWavelength * fKr4PI + fKm4PI));
		v3FrontColor = v3FrontColor + (v3Attenuate * vec3(fDepth * fScaledLength));
		v3SamplePoint += v3SampleRay;
	}

	// Finally, scale the Mie and Rayleigh colors and set up the varying variables for the pixel shader
	secondary_color = v3FrontColor * fKmESun;
	front_color = v3FrontColor * (v3InvWavelength * fKrESun);
	v3Direction = vecCamera - v3Pos;
}*/

void main(void)
{

	ex_vd_additional = in_additional;
	gl_Position = in_position;
	
	ex_vd_color = vec4(1.0);
/*
	vec3 front_color;
	vec3 secondary_color;
	vec3 v3Direction;
	CalcSunColors(in_position, secondary_color, front_color, v3Direction);
	ex_vd_color.xyz = CalcMie(front_color, secondary_color, v3Direction).xyz;
	ex_vd_color.w   = in_position.w;*/
}