#version 330 core
#extension GL_EXT_geometry_shader4 : enable
layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

uniform mat4 project;
uniform mat4 viewMatrix;
uniform mat4 viewMatrixInv;

uniform mat4 viewHalfAngleMatrix;
uniform mat4 invViewHalfAngleMatrix;	

uniform mat4 project_light;
uniform mat4 viewMatrix_light;

uniform mat3 un_dir_colors;

uniform vec3 un_light_pos;
uniform float un_timeOfDay;
uniform float un_fading;

uniform vec3 un_skyLight_h0;
uniform vec3 un_skyLight_h1;
uniform vec3 un_skyLight_t0;
uniform vec3 un_skyLight_t1;
uniform vec3 un_sunLight;


in vec4 ex_vd_additional[];
in vec4 ex_vd_color[];

out vec4 ex_texCoord;
out vec3 ex_mie;
out vec4 ex_additional;
out vec4 ex_position;


void main()                                                   
{	
	mat2 rot = mat2(1.0, 0.0, 0.0, 1.0);
	vec3 pos = (viewMatrix*gl_PositionIn[0]).xyz; // eye space

	float x1 = 10.0; float y1 = 10.0; 
	vec2 t1 = vec2(-x1,-y1); 
	vec2 t2 = vec2(-x1, y1); 
	vec2 t3 = vec2( x1,-y1); 
	vec2 t4 = vec2( x1, y1);
	
	vec4 v1 = vec4(pos.x+t1.x, pos.y+t1.y, pos.z, 1.0);
	vec4 v2 = vec4(pos.x+t2.x, pos.y+t2.y, pos.z, 1.0);
	vec4 v3 = vec4(pos.x+t3.x, pos.y+t3.y, pos.z, 1.0);
	vec4 v4 = vec4(pos.x+t4.x, pos.y+t4.y, pos.z, 1.0);
 
	vec4 mie = ex_vd_color[0];
	mat4 transformation = project;
		
	vec4 p = viewMatrixInv*v1;
	ex_texCoord = vec4(0.0, 0.0, 1.0, 1.0);	
	ex_mie = mie.xyz;
	ex_additional = ex_vd_additional[0];
	ex_position = p;	
	gl_Position = transformation * v1;
	EmitVertex();
	
	p = viewMatrixInv*v2;
	ex_texCoord = vec4(0.0, 1.0, 1.0, 1.0);	
	ex_mie = mie.xyz;
	ex_position = p;
	ex_additional = ex_vd_additional[0];
	gl_Position = transformation * v2;
	EmitVertex();

	p = viewMatrixInv*v3;
	ex_texCoord = vec4(1.0, 0.0, 1.0, 1.0);      
	ex_mie = mie.xyz;
	ex_position = p;
	ex_additional = ex_vd_additional[0];
	gl_Position = transformation * v3;
	EmitVertex();

	p = viewMatrixInv*v4;
	ex_texCoord = vec4(1.0, 1.0, 1.0, 1.0);
	ex_mie = mie.xyz;
	ex_position = p;
	ex_additional = ex_vd_additional[0];
	gl_Position =  transformation * v4;
	EmitVertex();
}  