#version 330 core
#extension GL_EXT_geometry_shader4 : enable
layout (location = 0) in vec4 in_position;
layout (location = 1) in vec4 in_rotation;
layout (location = 2) in vec4 in_centers;
layout (location = 3) in vec4 in_ids;
layout (location = 4) in vec3 in_bb_min;
layout (location = 5) in vec3 in_bb_max;

uniform mat4  viewMatrixInv;
uniform mat4  viewMatrix;
uniform vec3 un_light_pos;

out vec4 ex_vd_size;
out vec4 ex_vd_center;
out vec3 ex_vd_bb_min;
out vec3 ex_vd_bb_max;
out vec2 ex_vd_density;

void main(void)
{
	ex_vd_size.xy = in_rotation.yz;
	ex_vd_size.zw = in_ids.xy;
	ex_vd_center.xyz = in_centers.xyz;
	ex_vd_center.w = in_rotation.x;
	ex_vd_bb_min = in_bb_min;
	ex_vd_bb_max = in_bb_max;
	ex_vd_density.x = in_rotation.w;
	ex_vd_density.y = in_ids.w;

	gl_Position = in_position;	
}