#version 330 core
#extension GL_EXT_geometry_shader4 : enable
uniform sampler2D color_tex;
uniform sampler2D shadow_tex;

uniform mat3 un_dir_colors;
uniform float un_timeOfDay;

uniform float un_dens;
uniform float un_fading;

uniform mat4 project_light;
uniform mat4 modelViewMatrix_light;
uniform mat4 viewMatrix_light;
uniform mat4 viewMatrixInv_light;
uniform mat4 viewMatrix;

in vec4 ex_position;
in vec4 ex_texCoord;
in vec4 ex_ambient;
in vec4 ex_diffuse;
in vec3 ex_mie;
in vec3 ex_normal;
in vec2 ex_density;

uniform vec3 un_sunLight;
uniform vec3 un_light_pos;

uniform int backtofront;
uniform int backtofrontold;

out vec4 out_color;
out vec4 out_color2;

vec3 directionalColor(vec3 normal)
{	
	vec3 cmin = (un_dir_colors[0]*0.4)+(0.3*clamp(ex_mie.xyz-vec3(0.5, 0.5, 0.5), 0.0, 1.0));
	vec3 cmed = (un_dir_colors[1]*0.7)+(0.3*clamp(ex_mie.xyz-vec3(0.2, 0.2, 0.2), 0.0, 1.0));
	vec3 cmax = (un_dir_colors[2]*0.9)+(0.1*clamp(ex_mie.xyz-vec3(0.0, 0.0, 0.0), 0.0, 1.0));	

	float time_of_day = un_timeOfDay;
	
	vec3 c_t0 = vec3(0.4,0.4,0.4)*normalize(un_sunLight);
	vec3 c_t1 = vec3(1.0,1.0,1.0)*normalize(un_sunLight);

	vec3 sunPosition = un_light_pos;
	sunPosition.xyz = sunPosition.xzy;
	vec3 n1 = normalize(normal);
	vec3 n2 = normalize(un_light_pos);
	float dotres = clamp(dot(n1,n2),0.0,1.0);

	vec3 color;
	if (dotres < 0.0)
	{
		dotres += 1.0;
		color = ((1.0-dotres)*cmin) + (dotres*cmed);
	}
	else
	{
		color = ((1.0-dotres)*cmed) + (dotres*cmax);
	}
	
	return color* ( (1.0-time_of_day) * c_t0 + (1.0-(1.0-time_of_day))*c_t1);
	
}

void main(void)
{

	float index1 = floor(ex_texCoord.z+0.1);
	float findex1_x = int(mod(index1,4.0));
	float findex1_y = int(index1/4.0);	

	//float index2 = floor(ex_texCoord.w+0.1);
	float index2 = 10.0;
	float findex2_x = int(mod(index2,4.0));
	float findex2_y = int(index2/4.0);	

	float dens = un_dens;
	float dens2 = pow(ex_density.x, 1.50)*0.6;
	
	
	vec2 c1 =(vec2(findex1_x, findex1_y)*0.25)   + (ex_texCoord.xy*0.25);
	vec2 t = vec2(texture(color_tex, c1).x);
	float t2 = clamp(t.x,0.0,1.0);
	vec4 color = vec4(1.0); 	
	color.w *= dens2*pow(t2,1.0);
	color.w *= 0.5;
	
	vec3 N = vec3(0.0);
    N.xy = ex_texCoord.xy*vec2(2.0, 2.0) - vec2(1.0, 1.0);
    float mag = length(N);   	
    N.z = sqrt(2.0)-(mag);	
	N = normalize(N);		
	//N.y *= -1.0;
	
	//___________shadow____________
	vec4 shadowPos = project_light * viewMatrix_light * ex_position;	
	shadowPos = shadowPos / shadowPos.w;
	vec4 shadowP = shadowPos;	
	shadowPos.xyz *= vec3(0.5);
	shadowPos.xyz += vec3(0.5);
	
	float shadow = 0.0;
	vec4 shadowtex = texture(shadow_tex, shadowPos.xy);				
	//FALLS AUSSERHALB VON DER SHADOW MAP...
	//if(shadowPos.x < 0.0 || shadowPos.x > 1.0 || shadowPos.y < 0.0 || shadowPos.y > 1.0) shadow = vec4(0.0);		
	shadow = 1.0 - clamp(shadowtex.x*0.7, 0.0, 0.9);					
	//shadow = 1.0;
	
		
	vec3 lightPos = (viewMatrixInv_light * vec4(0,0,0,1)).xyz;	
	lightPos = normalize(lightPos);
	lightPos.xyz = lightPos.xyz;
	//lightPos.y *= -1.0;
	//lightPos = normalize(lightPos);
	
	//vec3 dir = directionalColor(ex_normal);
	vec3 dir = ex_diffuse.xyz;
	//color.xyz *= max(ex_ambient.xyz*1.50, vec3(0.5)) + 1.5*dir.xyz * max(0.000, pow(shadow,5.0) * (max(0.0, dot(-lightPos, N))));				
			
	float spec = max(0.0, dot(reflect(-lightPos, N), -(viewMatrixInv_light * glm::vec4(0.0, 0.0, 0.0, 1.0)).xyz));
	//float diff = max(0.0, dot(normalize(lightPos), N));
	
	vec4 lp = viewMatrixInv_light * glm::vec4(0.0,0.0,0.0,1.0);
	vec4 lightEye = viewMatrix * lp;//vec4(lightPos.xyz, 0.0);
	
	//if(backtofront != 0) 	N*=-1.0;
	
	float diff = min(1.0, max(0.0, dot(normalize(lightEye.xyz), N)));
	//color.xyz *= (ex_mie.xyz*1.0) + dir.xyz  + vec3(diff); //+1.0 *max(0.01, pow(shadow,5.0) * pow(max(0.0, spec),0.0));		
	//color.xyz *= ex_mie.xyz + dir.xyz + vec3(diff);
	//color.xyz *= ex_mie.xyz *0.65 + dir.xyz * 0.65 + vec3(diff	*0.9+0.1);
	
	color.xyz *= ex_mie.xyz *6.0 + vec3(0.3) + dir.xyz + vec3(diff*0.5);//vec3(0.50 + color.w*0.4) + 1.5*( /*ex_mie.xyz *2.5 +*/ dir.xyz *1.0 + vec3(diff*0.6));	
	//color.xyz *= vec3(1.0 + color.w*0.4) + 1.5*( ex_mie.xyz *2.5 + vec3(diff*0.6));	
	
		
					
	//color.xyz *= (ex_mie.xyz*1.0) + clamp(dir.xyz+ 2.0 * pow(max(0.01, shadow),20.0) * (max(0.0, dot(-lightPos, N)))),vec3(0.1),vec3(1.0));										
	//color.xyz = vec3(max(0.1100, pow(shadow,5.0) * (max(0.0, dot(-lightPos, N)))));
			
	//color.xyz = clamp(color.xyz, vec3(0.0), vec3(1.0));
	const float LOG2 = 1.442695;
	float z = gl_FragCoord.z / gl_FragCoord.w;
	float fogFactor = exp2(-pow(0.0005,2.f) *
							pow(z,2.0) *
							LOG2 );
	fogFactor = clamp(fogFactor, 0.0, 1.0);
		
		
	out_color = color;	
	out_color.xyz = clamp(out_color.xyz, vec3(0.0), vec3(2.0));
	out_color.xyz *= shadow * out_color.w;
	out_color.xyz *= vec3(2.0);
	out_color.w = clamp(out_color.w, 0.0, 1.0);
	
	//if(backtofront != 0) 
	//	out_color.xyz *= out_color.w;	
	out_color2 = vec4(0.0, 0.0, 0.0, out_color.w);			
	
	/*/
	vec3 N;                                                        
    N.xy = ex_texCoord.xy*vec2(2.0, -2.0) + vec2(-1.0, 1.0);    
    float r2 = dot(N.xy, N.xy);                                    
    if (r2 > 1.0) discard;   // kill pixels outside circle         
    N.z = sqrt(1.0-r2);                                            
        
	vec4 shadowPos = project_light * viewMatrix_light * ex_position;	
	shadowPos = shadowPos / shadowPos.w;
	vec4 shadowP = shadowPos;	
	shadowPos.xyz *= vec3(0.5);
	shadowPos.xyz += vec3(0.5);
	
	float shadow = 0.0;
	vec4 shadowtex = texture(shadow_tex, shadowPos.xy);				
	shadow = 1.0 - clamp(shadowtex.x, 0.0, 1.0);					
	if(shadowPos.x < 0.0 || shadowPos.x > 1.0 || shadowPos.y < 0.0 || shadowPos.y > 1.0) shadow = vec4(1.0);		
	
    float alpha = clamp((1.0 - r2), 0.0, 1.0);                         
	out_color = vec4(alpha);
	out_color.xyz *= out_color.w * shadow;
	out_color2 = vec4(1.0, 0.0, 0.0, out_color.w);			
	//*/
}