#version 330 core
#extension GL_EXT_geometry_shader4 : enable
layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

uniform mat4 project;
uniform mat4 viewMatrix;
uniform mat4 viewMatrixInv;

uniform mat3 un_dir_colors;

uniform vec3 un_light_pos;
uniform float un_timeOfDay;
uniform float un_fading;

uniform vec3 un_skyLight_h0;
uniform vec3 un_skyLight_h1;
uniform vec3 un_skyLight_t0;
uniform vec3 un_skyLight_t1;

uniform vec3 un_sunLight;

in vec4 ex_vd_color[];
in vec4 ex_vd_size[];
in vec4 ex_vd_center[];
in vec3 ex_vd_bb_min[];
in vec3 ex_vd_bb_max[];

out vec4 ex_texCoord;
out vec4 ex_ambient;
out vec4 ex_diffuse;
out vec3 ex_mie;
out vec4 ex_position;

vec3 ambientColor(float fragHeight, vec4 mie)
{
	vec3 cloudCenterPosition = (ex_vd_bb_max[0]  + ex_vd_bb_min[0]) / 2.0;
	float cloudHeight = ex_vd_bb_max[0].z-ex_vd_bb_min[0].z;
	//float timeOfDay = un_timeOfDay;
	float timeOfDay = 0.2;
	float layerBrightness = 0.1;

	vec3 skyLight_h0 = clamp(mie.xyz-vec3(0.35),0.0,1.0);
	vec3 skyLight_h1 = mie.xyz+vec3(0.05);

	vec3 sunPosition = normalize(un_light_pos);

	//float wsunpos = clamp(sunPosition.z, 0.0, 1.0);
	//skyLight_h0 = (1.0-sunPosition.z)*(mie.xyz+vec3(0.25)) + (sunPosition.z*(mie.xyz-vec3(0.25)));
	//skyLight_h1 = (1.0-sunPosition.z)*(mie.xyz-vec3(0.05)) + (sunPosition.z*(mie.xyz+vec3(0.05)));
	
	//h=0 -> bottom, h=1 -> top
	//float h = (((cloudCenterPosition.z + cloudHeight/2.0)-fragHeight) / cloudHeight);
	float transferFunc = (( fragHeight - (cloudCenterPosition.z - cloudHeight/2.0)) / cloudHeight );
		
	vec3 inCloudScattering = skyLight_h1*(transferFunc) + skyLight_h0*(1.0-transferFunc);
	//inCloudScattering = inCloudScattering*(1.0-layerBrightness);// + vec3(1.0, 1.0, 1.0)*layerBrightness;
	vec3 skyLight0 = un_skyLight_h0;
	vec3 skyLight1 = un_skyLight_h1;

	//vec3 ambientColor = (timeOfDay*skyLight0 + (1.0-timeOfDay)*skyLight1)*inCloudScattering;
	vec3 ambientColor = inCloudScattering;
	
	return ambientColor;//* (1.0+layerBrightness*0.5);	
}

vec3 directionalColor(vec4 worldpos, vec3 cloudCenterPosition, vec4 mie)
{	
	vec3 cmin = (un_dir_colors[0]*0.7)+(0.3*clamp(mie.xyz-vec3(0.5, 0.5, 0.5), 0.0, 1.0));
	vec3 cmed = (un_dir_colors[1]*0.7)+(0.3*clamp(mie.xyz-vec3(0.3, 0.3, 0.3), 0.0, 1.0));
	vec3 cmax = (un_dir_colors[2]*0.9)+(0.1*clamp(mie.xyz-vec3(0.0, 0.0, 0.0), 0.0, 1.0));
	/*/
	vec3 cmin = vec3(0.6, 0.6, 0.6);
	vec3 cmed = vec3(0.7, 0.7, 0.7);
	vec3 cmax = vec3(0.9, 0.9, 0.9);
	//*/

	float time_of_day = un_timeOfDay;
	
	vec3 c_t0 = vec3(1.0,1.0,1.0)*normalize(un_sunLight);
	vec3 c_t1 = vec3(1.3,1.3,1.3)*normalize(un_sunLight);

	vec3 sunPosition = un_light_pos;
	vec3 n1 = normalize(worldpos.xyz-cloudCenterPosition);
	vec3 n2 = normalize(un_light_pos);
	float dotres = dot(n1,n2);

	vec3 color;
	if (dotres < 0.0)
	{
		dotres += 1.0;
		color = ((1.0-dotres)*cmin) + (dotres*cmed);
	}
	else
	{
		color = ((1.0-dotres)*cmed) + (dotres*cmax);
	}
	
	return color* ( (1.0-time_of_day) * c_t0 + (1.0-(1.0-time_of_day))*c_t1);
	//return color* (c_t0);
	
}

float CalcTransparency(vec4 pos)
{
	vec3 cloudCenterPosition = (ex_vd_bb_max[0]  + ex_vd_bb_min[0]) / 2.0;

	float time = un_fading;
	float radius = length(ex_vd_bb_max[0]-cloudCenterPosition);	
	float length = length(pos.xyz-cloudCenterPosition);	
	
	if(time < -0.5 || time > 0.5)
	{
		time = abs(time);

		if(length < (radius/2.0))
		{
			return (1.0-time);
		}
		else return 0.0;
	}	
	else
	{
		time = abs(time);

		if(length < (radius/2.0))
		{
			return ((1.0-time));		
		}
		else
		{
			return (0.5-time)/0.5;		
		}
	}	
}

void main()                                                   
{
vec3 cloudCenterPosition = (ex_vd_bb_max[0]  + ex_vd_bb_min[0]) / 2.0;

	float cbeta = cos(ex_vd_center[0].w);	float sbeta = sin(ex_vd_center[0].w);
	mat2 rot = mat2(cbeta, -sbeta, sbeta, cbeta);
		
	vec3 pos = (viewMatrix*gl_PositionIn[0]).xyz; // eye space

	// rotation
	float x1 = ex_vd_size[0].x; float y1 = ex_vd_size[0].y; vec2 t1 = rot*vec2(-x1,-y1); vec2 t2 = rot*vec2(-x1, y1); vec2 t3 = rot*vec2( x1,-y1); vec2 t4 = rot*vec2( x1, y1);
		
	vec4 v1 = vec4(pos.x+t1.x, pos.y+t1.y, pos.z, 1.0);
	vec4 v2 = vec4(pos.x+t2.x, pos.y+t2.y, pos.z, 1.0);
	vec4 v3 = vec4(pos.x+t3.x, pos.y+t3.y, pos.z, 1.0);
	vec4 v4 = vec4(pos.x+t4.x, pos.y+t4.y, pos.z, 1.0);
 
	vec4 mie = ex_vd_color[0];
	mat4 transformation = project*viewMatrix;
		
	vec4 p = viewMatrixInv*v1;
	ex_texCoord = vec4(0.0, 0.0, ex_vd_size[0].z, ex_vd_size[0].w);
	ex_ambient = vec4(ambientColor(p.z, mie), CalcTransparency(p));
	ex_diffuse.xyz = min(directionalColor(p, ex_vd_center[0].xyz, mie), directionalColor(p, cloudCenterPosition, mie));
	ex_diffuse.w = clamp((p.z-ex_vd_bb_min[0].z) /(ex_vd_bb_max[0].z-ex_vd_bb_min[0].z),0.0,1.0);	
	ex_mie = mie.xyz;
	ex_position = p;
	gl_Position = transformation * p;
	EmitVertex();
	
	p = viewMatrixInv*v2;
	ex_texCoord = vec4(0.0, 1.0, ex_vd_size[0].z, ex_vd_size[0].w);
	ex_ambient = vec4(ambientColor(p.z, mie), CalcTransparency(p));
	ex_diffuse.xyz = min(directionalColor(p, ex_vd_center[0].xyz, mie), directionalColor(p, cloudCenterPosition, mie));	
	ex_diffuse.w = clamp((p.z-ex_vd_bb_min[0].z) /(ex_vd_bb_max[0].z-ex_vd_bb_min[0].z),0.0,1.0);	
	ex_mie = mie.xyz;
	ex_position = p;
	gl_Position = transformation * p;
	EmitVertex();

	p = viewMatrixInv*v3;
	ex_texCoord = vec4(1.0, 0.0, ex_vd_size[0].z, ex_vd_size[0].w);      
	ex_ambient = vec4(ambientColor(p.z, mie), CalcTransparency(p));
	ex_diffuse.xyz = min(directionalColor(p, ex_vd_center[0].xyz, mie), directionalColor(p, cloudCenterPosition, mie));
	ex_diffuse.w = clamp((p.z-ex_vd_bb_min[0].z) /(ex_vd_bb_max[0].z-ex_vd_bb_min[0].z),0.0,1.0);	
	ex_mie = mie.xyz;
	ex_position = p;
	gl_Position = transformation * p;
	EmitVertex();

	p = viewMatrixInv*v4;
	ex_texCoord = vec4(1.0, 1.0, ex_vd_size[0].z, ex_vd_size[0].w);
	ex_ambient = vec4(ambientColor(p.z, mie), CalcTransparency(p));
	ex_diffuse.xyz = min(directionalColor(p, ex_vd_center[0].xyz, mie), directionalColor(p, cloudCenterPosition, mie));
	ex_diffuse.w = clamp((p.z-ex_vd_bb_min[0].z) /(ex_vd_bb_max[0].z-ex_vd_bb_min[0].z),0.0,1.0);	
	ex_mie = mie.xyz;
	ex_position = p;
	gl_Position =  transformation * p;
	EmitVertex();
}  