#version 330 core
#extension GL_EXT_geometry_shader4 : enable
uniform sampler2D color_tex;

uniform float un_dens;
uniform float un_fading;

in vec4 ex_position;
in vec4 ex_texCoord;
in vec4 ex_ambient;
in vec4 ex_diffuse;
in vec3 ex_mie;

out vec4 out_color;
out vec4 out_color2;

void main(void)
{
	float index1 = floor(ex_texCoord.z+0.1);
	float findex1_x = int(mod(index1,4.0));
	float findex1_y = int(index1/4.0);	

	//float index2 = floor(ex_texCoord.w+0.1);
	float index2 = 10.0;
	float findex2_x = int(mod(index2,4.0));
	float findex2_y = int(index2/4.0);	

	float dens = un_dens;
	float dens2 = ex_diffuse.w;
	if(dens2 < 0.2)  	dens2 = 0.0;
	else	if(dens2 < 0.35) 
	{
		dens2 -= 0.2;
		dens2 /= 0.15;
	}
	else	dens2 = 1.0;
	
	
	vec2 c1 =(vec2(findex1_x, findex1_y)*0.25)   + (ex_texCoord.xy*0.25);
	vec2 c2 =(vec2(findex2_x, findex2_y)*0.25)   + (ex_texCoord.xy*0.25);
	vec2 t = vec2(texture(color_tex, c1).x, texture(color_tex, c2).w);
	vec4 color = vec4(1.0,1.0,1.0, mix(t.x, min(t.x,t.y), clamp(un_fading,0.0, 1.0)));
	color.w *= dens2*dens*ex_ambient.w;
	//color.xyz *= vec3(0.5, 0.5, 0.5); //Stratos

	color.xyz *= (ex_ambient.xyz*0.5) + (ex_diffuse.xyz*0.5);
	//color.xyz *= (ex_ambient.xyz);
	//color.xyz *= (ex_diffuse.xyz);
	
	const float LOG2 = 1.442695;
	float z = gl_FragCoord.z / gl_FragCoord.w;
	float fogFactor = exp2(-pow(0.0005,2.f) *
							pow(z,2.0) *
							LOG2 );
	fogFactor = clamp(fogFactor, 0.0, 1.0);	
	
	if (false && ( ex_texCoord.x < 0.005 || ex_texCoord.x > 0.995 || ex_texCoord.y < 0.005 || ex_texCoord.y > 0.9975))
		color = vec4(1.0);

	out_color = color;	
	out_color.xyz *= out_color.w*0.9;
	
	out_color2 = vec4(0.0, 0.0, 0.0, out_color.w);
}