#version 330 core
#extension GL_EXT_geometry_shader4 : enable
layout (points) in;
layout (triangle_strip, max_vertices = 4) out;
    
uniform float size;

uniform mat4 project_light;
uniform mat4 modelViewMatrix_light;
uniform mat4 viewMatrix_light;
uniform mat4 viewMatrixInv_light;

/*uniform mat4 viewHalfAngleMatrix;
uniform mat4 invViewHalfAngleMatrix;

uniform mat4 viewHalfAngleLightMatrix;
uniform mat4 invViewHalfAngleLightMatrix;*/

in vec4 ex_vd_color[];
in vec4 ex_vd_size[];
in vec4 ex_vd_center[];
in vec2 ex_vd_density[];

out vec4 ex_texCoord;
out vec2 ex_ambient;
out vec4 ex_pos;
out vec2 ex_density;

float CalcTransparency(vec4 center, vec4 pos)
{
	float time = 1.0;
	float radius = 3.0;	

	return 0.14;	
}

void main()                                                   
{           
	mat4 model = viewMatrixInv_light * modelViewMatrix_light;
	
	vec4 lightPos = viewMatrixInv_light * vec4(0.0,0.0,0.0,1.0);
                                                  	
	// eye space
	vec3 pos = ( viewMatrix_light * model * gl_in[0].gl_Position).xyz;
	
	vec3 x = vec3(1.0, 0.0, 0.0);
	vec3 y = vec3(0.0, 1.0, 0.0);
	
	float cbeta = cos(ex_vd_center[0].w);	float sbeta = sin(ex_vd_center[0].w);
	mat2 rot = mat2(1.0, 0.0, 0.0, 1.0);//mat2(cbeta, -sbeta, sbeta, cbeta);

	// rotation
	vec2 s = vec2(1.0, 1.0);
	//s = vec2(0.4, 0.4);
	float x1 = ex_vd_size[0].x*s.x; float y1 = ex_vd_size[0].y*s.y; vec2 t1 = rot*vec2(-x1,-y1); vec2 t2 = rot*vec2(-x1, y1); vec2 t3 = rot*vec2( x1,-y1); vec2 t4 = rot*vec2( x1, y1);

	vec4 v1 = vec4(pos.x+t1.x, pos.y+t1.y, pos.z, 1.0);
	vec4 v2 = vec4(pos.x+t2.x, pos.y+t2.y, pos.z, 1.0);
	vec4 v3 = vec4(pos.x+t3.x, pos.y+t3.y, pos.z, 1.0);
	vec4 v4 = vec4(pos.x+t4.x, pos.y+t4.y, pos.z, 1.0);
 
	vec4 center = vec4(0.0);
	mat4 transformation = project_light*viewMatrix_light;
	
	vec4 worldPos = vec4(0.0);

	vec4 p = viewMatrixInv_light*v1;
	ex_texCoord = vec4(0.0, 0.0, ex_vd_size[0].z, ex_vd_size[0].w);
	ex_ambient = vec2(CalcTransparency(center, worldPos), ex_vd_color[0]);
	ex_pos = viewMatrix_light*p;
	ex_density = ex_vd_density[0];
	gl_Position = transformation * p;	
	EmitVertex();
	
	p = viewMatrixInv_light*v2;
	ex_texCoord = vec4(0.0, 1.0, ex_vd_size[0].z, ex_vd_size[0].w);
	ex_ambient = vec2(CalcTransparency(center, worldPos), ex_vd_color[0]);
	ex_pos = viewMatrix_light*p;
	ex_density = ex_vd_density[0];
	gl_Position = transformation * p;
	EmitVertex();

	p = viewMatrixInv_light*v3;
	ex_texCoord = vec4(1.0, 0.0, ex_vd_size[0].z, ex_vd_size[0].w);      
	ex_ambient = vec2(CalcTransparency(center, worldPos), ex_vd_color[0]);
	ex_pos = viewMatrix_light*p;
	ex_density = ex_vd_density[0];
	gl_Position = transformation * p;
	EmitVertex();

	p = viewMatrixInv_light*v4;
	ex_texCoord = vec4(1.0, 1.0, ex_vd_size[0].z, ex_vd_size[0].w);
	ex_ambient = vec2(CalcTransparency(center, worldPos), ex_vd_color[0]);
	ex_pos = viewMatrix_light*p;
	ex_density = ex_vd_density[0];
	gl_Position =  transformation * p;
	EmitVertex();
}  