#version 330 compatibility
#extension GL_EXT_geometry_shader4 : enable

uniform sampler2D color_tex;
uniform sampler2D shadow_tex;

uniform mat3 un_dir_colors;
uniform float un_timeOfDay;

uniform float un_dens;
uniform float un_fading;

uniform mat4 project_light;
uniform mat4 modelViewMatrix_light;
uniform mat4 viewMatrix_light;
uniform mat4 viewMatrixInv_light;
uniform mat4 viewMatrix;

uniform mat4 ProjectionMatrix;
uniform mat4 light_mv_matrix;

uniform int backtofront;

in vec4 ex_position;
in vec4 ex_texCoord;
in vec4 ex_ambient;
in vec4 ex_diffuse;
in vec3 ex_normal;
in vec2 ex_density;
in vec3 p;
in vec4 ex_color;

in vec3 ex_cloudColor;
in vec3 ex_extinction;
in vec3 ex_inscatter;

uniform vec3 un_sunLight;
uniform vec3 un_light_pos;

uniform float fogdensity;

out vec4 out_color;
out vec4 out_color2;

vec3 directionalColor(vec3 normal, vec3 lightdir)
{	
	vec4 ex_mie = vec4(1.0);
	vec3 cmin = vec3(0.1);// (un_dir_colors[0]*0.4);//+(0.3*clamp(ex_mie.xyz-vec3(0.5, 0.5, 0.5), 0.0, 1.0));
	vec3 cmed = vec3(0.2);//(un_dir_colors[1]*0.7);//+(0.3*clamp(ex_mie.xyz-vec3(0.2, 0.2, 0.2), 0.0, 1.0));
	vec3 cmax = vec3(0.5);//(un_dir_colors[2]*0.9);//+(0.1*clamp(ex_mie.xyz-vec3(0.0, 0.0, 0.0), 0.0, 1.0));	

	float time_of_day = un_timeOfDay;
	
	vec3 c_t0 = vec3(0.4,0.4,0.4);//*normalize(un_sunLight);
	vec3 c_t1 = vec3(1.0,1.0,1.0);//*normalize(un_sunLight);
	
	vec3 n1 = normalize(normal);
	vec3 n2 = normalize(lightdir);
	float dotres = clamp(dot(n1,n2),0.0,1.0);

	vec3 color;
	if (dotres < 0.0)
	{
		dotres += 1.0;
		color = ((1.0-dotres)*cmin) + (dotres*cmed);
	}
	else
	{
		color = ((1.0-dotres)*cmed) + (dotres*cmax);
	}
	
	return color* ( (1.0-time_of_day) * c_t0 + (1.0-(1.0-time_of_day))*c_t1);
	
}


void main(void)
{
	float index1 = floor(ex_texCoord.z+0.1);
	float findex1_x = int(mod(index1,4.0));
	float findex1_y = int(index1/4.0);	

	float index2 = floor(ex_texCoord.w+0.1);
	//float index2 = 10.0;
	float findex2_x = int(mod(index2,4.0));
	float findex2_y = int(index2/4.0);	
	
	float dens2 = pow(ex_density.x, 1.50)*0.86;
	
	
	vec2 c1 =(vec2(findex1_x, findex1_y)*0.25)   + (ex_texCoord.xy*0.25);
	vec2 t = vec2(texture(color_tex, c1).x);
	float t2 = clamp(t.x,0.0,1.0);
	vec4 color = vec4(1.0); 	
	color.w *= dens2*pow(t2,1.0);
	color.w *= 0.5;
	
	vec3 N = vec3(0.0);
    N.xy = ex_texCoord.xy*vec2(2.0, 2.0) - vec2(1.0, 1.0);
    float mag = length(N);   	
    N.z = sqrt(2.0)-(mag);	
	N = normalize(N);		
	//N.y *= -1.0;
	
	
	//___________shadow____________
	vec4 shadowPos = project_light * viewMatrix_light * ex_position;	
	shadowPos = shadowPos / shadowPos.w;
	vec4 shadowP = shadowPos;	
	shadowPos.xyz *= vec3(0.5);
	shadowPos.xyz += vec3(0.5);
	
	float shadow = 0.0;
	vec4 shadowtex = texture(shadow_tex, shadowPos.xy);				
	
	shadow = 1.0 - clamp(shadowtex.x*0.9, 0.0, 1.0);				
		
	vec3 lightPos = (viewMatrixInv_light * vec4(0,0,0,1)).xyz;	
	lightPos = normalize(lightPos);
	lightPos.xyz = lightPos.xyz;
	//lightPos.y *= -1.0;
	//lightPos = normalize(lightPos);
	
	vec3 dir = directionalColor(ex_normal, normalize(lightPos));
			
	color.xyz = vec3(ex_color.x*0.02, ex_color.y*0.02, ex_color.z*0.02) +
		clamp(vec3(ex_color.x*dir.x*0.5, ex_color.y*dir.y*0.5, ex_color.z*dir.z*0.5) ,vec3(0.0),vec3(1.0)) + (ex_cloudColor * ex_extinction + ex_inscatter)*0.8;
		//  + vec3(clamp(dot(-lightPos, N), 0.1, 1.0)) ;			
	//color.xyz = (ex_cloudColor * ex_extinction + ex_inscatter)*0.7 + 0.3*vec3(clamp(dot(normalize(lightPos), N), 0.1, 1.0)) ;			
	//color.xyz = (ex_cloudColor * ex_extinction + ex_inscatter)*0.7 + 0.4*clamp(dir.xyz*1.0,vec3(0.0),vec3(1.0));
	
	//color.xyz =  clamp(dot(lightPos, ex_normal), 0.1, 1.0) * ex_extinction;	
	
	color.xyz = clamp(color.xyz, vec3(0.0), vec3(1.5));
		
	const float LOG2 = 1.442695;
	float z = gl_FragCoord.z / gl_FragCoord.w;
	float fogFactor = exp2(-pow(0.0005,2.f) *
							pow(z,2.0) *
							LOG2 );
	fogFactor = clamp(fogFactor, 0.0, 1.0);	
		
	out_color = color;		
	out_color.w *= 0.75;		
	out_color.xyz*=2.25;
	
	out_color.xyz = mix(vec3(0.8, 0.8, 0.8), out_color.xyz, clamp(fogFactor+1.0-fogdensity, 0.0, 1.0));	
	out_color.xyz *= shadow * out_color.w;
	
	out_color2 = vec4(1.0, 0.0, 0.0, out_color.w);				
}