#version 330 core
uniform sampler2D color_tex;
uniform float texsize;

in vec2 ex_texcoord;
out vec4 out_color;

void main()
{
	out_color=vec4(0.0);
	/*
	for (int j=0; j<4; j++)	
	{
		for (int i=0; i<4; i++) 		
		{
			out_color += texture( color_tex, vec2(  gl_FragCoord.x/texsize, 
													gl_FragCoord.y/texsize)
											+ vec2( 0.5/texsize*4.0, 
													0.5/texsize*4.0)
											+ vec2( float(i-2)/(texsize*4.0), 
													float(j-2)/(texsize*4.0)));
		}
	}
	out_color /= 16.0;
	*/
	
	//USE OF LINEAR INTERPLOATION: 
	//LINEAR INTERPOLATION RESULT IN THE AVG of 4 Pixels at the corner
	//Instead of calculation of the average from 16 pixels, we only use 4 pixels.
	//The average of the other pixels is done by the linear interpolation.	
	out_color += texture( color_tex, vec2(  gl_FragCoord.x/texsize, 
											gl_FragCoord.y/texsize)
									+ vec2( -1.0/(texsize*4.0), 
											-1.0/(texsize*4.0)));
	out_color += texture( color_tex, vec2(  gl_FragCoord.x/texsize, 
											gl_FragCoord.y/texsize)
									+ vec2( -1.0/(texsize*4.0), 
											 1.0/(texsize*4.0)));
	out_color += texture( color_tex, vec2(  gl_FragCoord.x/texsize, 
											gl_FragCoord.y/texsize)
									+ vec2(  1.0/(texsize*4.0), 
											-1.0/(texsize*4.0)));
	out_color += texture( color_tex, vec2(  gl_FragCoord.x/texsize, 
													gl_FragCoord.y/texsize)
											+ vec2(  1.0/(texsize*4.0), 
													 1.0/(texsize*4.0)));
	out_color /= 4.0;												
	//out_color = texture( color_tex, ex_texcoord)/10.0 + 0.1;
}