#version 330 compatibility

uniform mat4 ModelMatrix;
uniform mat4 ViewMatrix;
uniform mat4 osg_ViewMatrix;
uniform mat4 ProjectionMatrix;
uniform mat4 light_mv_matrix;

layout(location=0) in vec3 vertex;
out vec3 dir;
out vec3 relativeDir;

void main() {

	mat4 Model = ModelMatrix ;
	mat4 lightMatrix = light_mv_matrix*inverse(Model);

    vec3 WSD = normalize( (inverse(lightMatrix) * vec4(0.0,0.0,0.0,1.0)).xyz);

    dir = (inverse(osg_ViewMatrix)* vec4((inverse(ProjectionMatrix) * vec4(vertex.xyz, 1.0)).xyz, 0.0)).xyz;

    // construct a rotation that transforms sundir to (0,0,1);
    float theta = acos(WSD.z);
    float phi = atan(WSD.y, WSD.x);
    mat3 rz = mat3(cos(phi), -sin(phi), 0.0, sin(phi), cos(phi), 0.0, 0.0, 0.0, 1.0);
    mat3 ry = mat3(cos(theta), 0.0, sin(theta), 0.0, 1.0, 0.0, -sin(theta), 0.0, cos(theta));
    // apply this rotation to view dir to get relative viewdir
    relativeDir = (ry * rz) * dir;    
		
	gl_Position.xyz = vertex.xyz;	
	gl_Position.z = 0.99999;
	gl_Position.w = 1.0;
	gl_Position = gl_Position;
}