#pragma once
#include "Scene.h"
#include "CloudCreateVolume.h"
#include <osgViewer/Viewer>

#include <osg/ShapeDrawable>
#include <osgViewer/ViewerEventHandlers>
#include <osgDB/ReadFile>
#include <osg/Texture2D>
#include <osgGA/StateSetManipulator>
#include <osg/Program>
#include <osg/PolygonMode>
#include <osg/Notify>
#include <osg/ref_ptr>
#include <osg/Geode>
#include <osg/Geometry>
#include <osg/Point>
#include <osg/Vec3>
#include <osg/Vec4>
#include <osg/Program>
#include <osg/Shader>
#include <osg/Uniform>
#include <osg/BlendFunc>
#include <osg/Depth>
#include <osgViewer/Viewer>

#include <iostream>
#include <algorithm>

namespace osgCloudyDay
{
	class CloudGenerator;

	/**
	 * Container class (like vertices, texture coordantes and so on) for 3D clouds
	 */
	class WangCloud
	{
	public:
		/**
		 * Standardconstructor
		 */
		WangCloud(void);
		/**
		 * Standardconstructor
		 * @param category type of cloud
		 */
		WangCloud(int category);
		/**
		 * Standardconstructor
		 * @param category type of cloud
		 * @param vertices vertices array of the cloud
		 * @param rotation rotation array of the cloud
		 * @param center center of the cloud
		 * @param boxcenters boxcenters of the cloud
		 * @param ambientlight_h ambientlight_h of the cloud
		 * @param ambientlight_t ambientlight_t of the cloud
		 * @param diffuselight diffuselight of the cloud
		 * @param color color of the cloud
		 */
		WangCloud(int category, 
			osg::ref_ptr<osg::Vec3Array> vertices, 
			osg::ref_ptr<osg::Vec4Array> rotation, 
			osg::ref_ptr<osg::Vec4Array> center, 
			osg::ref_ptr<osg::Vec4Array> ids, 
			osg::ref_ptr<osg::Vec4Array> boxcenters, 
			osg::ref_ptr<osg::Vec3Array> ambientlight_h, 
			osg::ref_ptr<osg::Vec3Array> ambientlight_t, 
			osg::ref_ptr<osg::Vec3Array> diffuselight, 
			osg::ref_ptr<osg::Vec4Array> color);
		/**
		 * Standarddeconstructor
		 */
		~WangCloud(void);

		/**
		 * Returns the number of particles
		 * @return number of particles
		 */
		int GetNumberOfParticles();

		/**
		 * Calculates the BoundingBox
		 */
		void GetBoundingBox();

		/**
		 * Returns the Maximum position of the bounding box
		 * @return maximum
		 */
		osg::Vec3 BoundingBoxMax();
		/**
		 * Returns the minima position of the bounding box
		 * @return maxima
		 */
		osg::Vec3 BoundingBoxMin();

		/**
		 * Set textures and other states
		 */
		void Setup();

		/**
		 * Returns the vertices array of the cloud
		 * @return vertices array
		 */
		osg::Vec3Array* GetVertices();

		void SetVertices(osg::Vec3Array* ar);
		/**
		 * Returns the rotation array of the cloud
		 * @return rotation array
		 */
		osg::Vec4Array* GetRotation();

		void SetRotation(osg::Vec4Array* ar);
		/**
		 * Returns the color array of the cloud
		 * @return color array
		 */
		osg::Vec4Array* GetColor();

		void SetColor(osg::Vec4Array* color);
		/**
		 * Returns the center array of the cloud
		 * @return center array
		 */
		osg::Vec4Array* GetCenter();

		void SetCenter(osg::Vec4Array* cen);

		/**
		 * Returns the texture ides array of the cloud
		 * @return texture ids
		 */
		osg::Vec4Array* GetIds();

		void SetIds(osg::Vec4Array* ids);
		/**
		 * Returns the boxcenters array of the cloud
		 * @return box centers
		 */
		osg::Vec4Array* GetBoxCenters();	
		/**
		 * Returns the number of vertices of the cloud
		 * @return number of vertices
		 */
		int& GetNumberOfIndices();

		/**
		 * Method sets the cloud generator
		 * @param cloud generator
		 */
		void SetCloudGenerator(CloudGenerator* generator);

		/**
		 * Method returns the cloud geneator
		 * @return cloud generator
		 */
		CloudGenerator* GetCloudGenerator();

		void AddBoundingBox(osg::Vec3 origin, osg::Vec3 size, int startindex, int num_objects);
		void ClearBoundingBox();

		unsigned int GetBoundingBoxEndIndex(int at);
		unsigned int GetBoundingBoxStartIndex(int at);
		osg::Vec3 GetBoundingBoxOriginAt(int at);
		osg::Vec3 GetBoundingBoxSizeAt(int at);
		unsigned int GetNumberOfBoundingBoxes();

		void SetBoundingBoxStart(int n, size_t index);
		void SetBoundingBoxEnd(int n, size_t index);

		void EraseBoundingBoxAtIndex(int m);

	protected:
		CloudGenerator* m_generator;

		int num_indices;	
		osg::ref_ptr<osg::Vec3Array> vertices;
		osg::ref_ptr<osg::Vec4Array> rotation;
		osg::ref_ptr<osg::Vec4Array> center;
		osg::ref_ptr<osg::Vec4Array> ids;
		osg::ref_ptr<osg::Vec4Array> box_centers;
		osg::ref_ptr<osg::Vec4Array> color;

		
		std::vector<osg::Vec3> boundingboxes;
		std::vector<osg::Vec3> boundingboxes_size;
		std::vector<unsigned int> boundingboxes_start;
		std::vector<unsigned int> boundingboxes_end;
		std::vector<std::vector<int>> m_bb2particle;

		osg::Vec3 bb_min;
		osg::Vec3 bb_max;

		unsigned int m_type;
	
	};
}