#pragma once
#include <osg/Image>
#include <osg/Geometry>
#include <osg/Image>
#include <osg/Texture2D>
#include <osg/Texture3D>
#include <osgViewer/CompositeViewer>
#include <iostream>
#include <map>
#include <osg/BoundingBox>
#include <osg/MatrixTransform>

namespace osgCloudyDay
{
	class ReadBufferCallback: public osg::Camera::DrawCallback
{
public:
	static float* m_data;
	int m_layer;
	osg::Texture3D* tex;
	osg::Image* image;
	osg::FrameBufferObject* fbo;
	osg::FrameBufferAttachment *fba;

	int m_slicex;
	int m_slicey;

	ReadBufferCallback(osg::Texture3D *_tex, int slicex, int slicey, int layer) : m_layer(layer), m_slicex(slicex), m_slicey(slicey)
	{
		tex = _tex;
		image = new osg::Image();
		fbo = new osg::FrameBufferObject();
		fba = new osg::FrameBufferAttachment(tex, layer);
		fbo->setAttachment(osg::Camera::COLOR_BUFFER, *fba);		
	}

	virtual void operator() (osg::RenderInfo& renderInfo) const
	{
		fbo->apply(*(renderInfo.getState()), osg::FrameBufferObject::READ_FRAMEBUFFER);
		image->readPixels(0, 0, m_slicex, m_slicey, GL_RGBA, GL_FLOAT);
		
		float* height = (float*)image->data();

		osg::Vec4 sum = osg::Vec4(0.f, 0.f, 0.f, 0.f);
		for(int i = 0; i < m_slicex*m_slicey; i++)
		{
			for(int j = 0; j < 4; j++)
				m_data[m_layer*m_slicey*m_slicex*4+i*4+j] = height[i*4+j];

			sum.x() += height[i*4+0];
			sum.y() += height[i*4+1];
			sum.z() += height[i*4+2];
			sum.w() += height[i*4+3];
			//	std::cout << "height: " << height[i*4] << " " <<height[i*4+1] << " " <<height[i*4+2]<< " " <<height[i*4+3]<< std::endl;
		}
		//std::cout << "SUM: " << sum.x() << " " << sum.y() << " " << sum.z() << " " << sum.z() << std::endl;		
		//std::cout << std::endl;
	}
}; 

	class  CcalculateBoundingBox : public osg::NodeVisitor 
{
public:
     CcalculateBoundingBox() : NodeVisitor( NodeVisitor::TRAVERSE_ALL_CHILDREN ) 
	 {
		 // ----------------------------------------------------------------------
		 //
		 //     Default Public Class Constructor
		 //
		 // ----------------------------------------------------------------------
         m_transformMatrix.makeIdentity();
    }

    virtual ~CcalculateBoundingBox() {}
    virtual void apply( osg::Geode &geode ) 
	{
		// -------------------------------------------
		//
		//   Handle nodes of the type osg::Geode
		//
		// -------------------------------------------
        osg::BoundingBox bbox;
       
        //
        // update bounding box for each drawable
        //
        for(  unsigned int i = 0; i < geode.getNumDrawables(); ++i ){           
            //
            // expand the overall bounding box
            //
            bbox.expandBy( geode.getDrawable( i )->getBound());
        }

        //
        // transform corners by current matrix
        //
        osg::BoundingBox bboxTrans;

        for( unsigned int i = 0; i < 8; ++i ) 
		{      
            osg::Vec3 xvec = bbox.corner( i ) * m_transformMatrix;
            bboxTrans.expandBy( xvec );
        }

        //
        // update the overall bounding box size
        //
        m_boundingBox.expandBy( bboxTrans ); 

        //
        // continue traversing through the graph
        //
	    traverse( geode );
       
    } // ::apply(osg::Geode &geode)
     
    virtual  void apply( osg::MatrixTransform &node ) 
	{
		// ---------------------------------------------------------
		//
		//   Handle nodes of the type osg::MatrixTransform
		//
		// ---------------------------------------------------------
        m_transformMatrix *= node.getMatrix(); 
        
		//
        // continue traversing through the graph
        //
        traverse( node ); 

	} // ::apply(osg::MatrixTransform &node)

    virtual void apply( osg::Billboard &node ){

    // -----------------------------------------------
    //
    //    Handle nodes of the type osg::Billboard
    //
    // -----------------------------------------------
    
        //
        // important to handle billboard so that its size will
        // not affect the geode size continue traversing the graph
        //

        traverse( node );
    } // ::apply(osg::MatrixTransform &node)

    //
    // return teh bounding box     
    //
    osg::BoundingBox &getBoundBox() { return m_boundingBox; }  

protected :
    osg::BoundingBox m_boundingBox;          // the overall resultant bounding box
    osg::Matrix      m_transformMatrix;      // the current transform matrix 

};  // class  CcalculateBoundingBox

	class VoxelizeMesh
	{
	public:
		typedef std::map<GLint, osg::Texture3D*> t_tex3DsByUnit;

	public:
		VoxelizeMesh(std::string path, int slice_width, int slice_height, int slice_depth);
		~VoxelizeMesh(void);	
	
		void Perform();	
		osg::Vec4 GetData(int x, int y, int z);

		osg::ref_ptr<osg::Texture3D> voxels_tex;

		osg::BoundingBox m_boundingbox;

	private:
		void Read3DTexture();

		osg::Texture3D* setupTexture3D( const char *name,   const GLenum internalFormat,   const GLenum pixelFormat,   const GLenum dataType,   const int width,   const int height,   const int depth,   osg::Image *image=0);

		void Render3D(osg::Vec4 color, bool clear);

		//osg::Geode *genQuad() const;
		void cleanUp(osgViewer::CompositeViewer *viewer);
		void dirtyTargets(t_tex3DsByUnit &targets3D);
		osg::GraphicsContext *setupContext();

		osg::Camera *setupCamera( const int orderNum, bool clear);
		osg::Image *getLayerFrom3DImage(osg::Image *source,   const int layer);
		osg::Group *setupGroup(osgViewer::CompositeViewer *viewer);

		osg::ref_ptr<osg::Program> m_shader;
	
	private:
		float* m_data;

		int viewportWidth;
		int viewportHeight;

		int m_slice_depth;

		t_tex3DsByUnit targets3D;
		osgViewer::CompositeViewer *viewer;
		osg::ref_ptr<osg::Group> group;
	};
}