#pragma once
#include "terrain.h"

namespace osgCloudyDay
{
	/**
	 * Class to create a terrain with the bruneton approach
	 */
	class TerrainHimmel  :	public osgCloudyDay::MyTerrain
	{
	public:
		/**
		 * Constructor
		 * @param config configuration of the terrain
		 * @param use_tesselation_shader should the tesselation shader approach be used
		 */
		TerrainHimmel(TerrainConfig* config, bool use_tesselation_shader);
		/**
		 * Deconstructor
		 */
		~TerrainHimmel(void);

		/**
		 * Initalize method, creates the terrain
		 */
		virtual void Initialize();		

		/**
		 * Returns the first texture to calculate the lightshaft
		 * @return lightshaft texture
		 */
		osg::ref_ptr<osg::Texture2D> GetLightshaft1();
		/**
		 * Returns the second texture to calculate the lightshaft
		 * @return lightshaft texture
		 */
		osg::ref_ptr<osg::Texture2D> GetLightshaft2();

		/**
		 * Method to pass the lightshaft1 texture
		 * @param tex texture to lightshaft 1
		 */
		void SetLightshaft1(osg::ref_ptr<osg::Texture2D> tex);
		/**
		 * Method to pass the lightshaft2 texture
		 * @param tex texture to lightshaft 2
		 */
		void SetLightshaft2(osg::ref_ptr<osg::Texture2D> tex);

	protected:
		osg::ref_ptr<osg::Texture2D> fbo_lightshaft1;
		osg::ref_ptr<osg::Texture2D> fbo_lightshaft2;
	};
}