#pragma once
#include <string>
#include <vector>

namespace osgCloudyDay
{
	/**
	 * Class to configure the terrain
	 */
	class TerrainConfig
	{
	public:
		/**
		 * Constructor
		 */
		TerrainConfig(void);
		/**
		 * Deconstructor
		 */
		~TerrainConfig(void);

		/**
		 * Set the path to the 3D model
		 * @param path to 3D model
		 */
		void SetPath2File(std::string path);
		/**
		 * Returns the path to the 3D model
		 * @return path to the 3D model
		 */
		std::string GetPath2File();

		/**
		 * Set the path to the diffuse texture
		 * @param path to diffuse texture
		 */
		void SetPath2DiffuseTexture(std::string path);
		/**
		 * Returns the path to the diffuse texture
		 * @return path to the diffuse texture
		 */
		std::string GetPath2DiffuseTexture();

		/**
		 * Set the path to the definition texture
		 * @param path to definition texture
		 */
		void SetPath2DefinationTexture(std::string path);
		/**
		 * Returns the path to the definition texture
		 * @return path to the definition texture
		 */
		std::string GetPath2DefinationTexture();

		/**
		 * Set the path to the height texture
		 * @param path to height texture
		 */
		void SetPath2HeightTexture(std::string path);
		/**
		 * Returns the path to the height texture
		 * @return path to the height texture
		 */
		std::string GetPath2HeightTexture();

		/**
		 * Returns the number of textures
		 * @return number of textures
		 */
		int GetNumberOfTexture();		
		/**
		 * Method to add a texture
		 * @path path to the texture
		 */
		void AddPath2Texture(std::string path);
		/**
		 * Method returns the path to a texture
		 * @param at texture id
		 * @return path to the texture
		 */
		std::string GetPathAt(int at);

		/**
		 * Returns the number of normal textures
		 * @return number of normal textures
		 */
		int GetNumberOfNormalTexture();
		/**
		 * Method to add a normal texture
		 * @path path to the normal texture
		 */
		void AddPath2NormalTexture(std::string path);
		/**
		 * Method returns the path to a normal texture
		 * @param at texture id
		 * @return path to the normal texture
		 */
		std::string GetNormalPathAt(int at);

		/**
		 * Returns, if the tesselation shader should be used
		 * @return tesselation shader? yes/no
		 */
		bool UseTesselationShader();
		/**
		 * Method sets, if the tesselation shader should be used
		 * @param value tesselation shader? yes/no
		 */
		void SetTesselationShader(bool value);

	protected:
		bool m_use_geometry_shader;
		std::string m_path2file;
		std::string m_diffuse_texture;
		std::string m_heightmap;
		std::string m_defination;
		std::vector<std::string> m_textures;
		std::vector<std::string> m_textures_normal;
	};
}