#pragma once
#include "Scene.h"
#include "TerrainConfig.h"
#include "Fog.h"

namespace osgCloudyDay
{
	/**
	 * Parent class to create a terrain.
	 */
	class MyTerrain
	{
	public:
		/**
		 * Constructor
		 * @param config configuration of the terrain
		 */
		MyTerrain(TerrainConfig* config);
		/**
		 * Deconstructor
		 */
		~MyTerrain(void);

		/**
		 * Initalize method, creates the terrain
		 */
		virtual void Initialize() = 0;

		/**
		 * Returns the node to integrate it into the viewer camera
		 * @return node
		 */
		osg::MatrixTransform* GetNode();
		/**
		 * Returns the node to integrate it into the light source camera
		 * @return node
		 */
		osg::MatrixTransform* GetLightNode();		

		/**
		 * Set function for fog
		 * @param Fog class, which saves the fog.
		 */
		void SetFog(Fog* fog);		

		/**
		 * Returns the height texture of the terrain
		 * @return node
		 */
		osg::ref_ptr<osg::Texture2D> GetHeightTexture();
		/**
		 * Returns the definition texture of the terrain
		 * @return node
		 */
		osg::ref_ptr<osg::Texture2D> GetDefinitionTexture();
		/**
		 * Returns the orthogonal texture of the terrain
		 * @return node
		 */
		osg::ref_ptr<osg::Texture2D> GetOrthogonalTexture();

	protected:
		Fog* m_fog;

		osg::ref_ptr<osg::Texture2D> tex_height;
		osg::ref_ptr<osg::Texture2D> tex_def;
		osg::ref_ptr<osg::Texture2D> tex_ortho;	

		TerrainConfig* m_config;

		osg::ref_ptr<osg::Program> terrainShadowProg;
		osg::ref_ptr<osg::Program> mieTerrainProg;
		osg::ref_ptr<osg::MatrixTransform> trans;	
		osg::ref_ptr<osg::MatrixTransform> trans_light;	

		bool m_use_geometry_shader;
	};
}