#pragma once
#include "CloudGenerator.h"

namespace osgCloudyDay
{
	/**
	 * Stratus cumulus Generator: Generates static stratus cumulus cloud
	 */
	class StratoCumulusGenerator : public CloudGenerator
	{
	public:
		/**
		 * Standardconstructor
		 * @param color color of the cloud.
		 */
		StratoCumulusGenerator(osg::Vec4 layer);
		/**
		 * Standarddeconstructor
		 */
		~StratoCumulusGenerator(void);

	protected:
		/**
		 * Initialize creates the boxes and sprites which are needed to create a Stratus Cumulus cloud.
		 */
		void Initialize();

		/**
		 * Updates the cloud
		 */
		bool Update();
	};
}