#pragma once
#include "Skydome.h"

namespace osgCloudyDay
{
	/** 
	 * Skydome class for O'Neal apprach
	 */
	class SkydomeMie : public osgCloudyDay::Skydome
	{
	public:
		/**
		 * Constructor: Initialize Skydome with predefined values
		 */
		SkydomeMie(void);

		/**
		 * Standard deconstrutor
		 */
		~SkydomeMie(void);	

		/**
		 * Returns the inner radius of the skydome
		 * @return inner radius of the skydome
		 */
		float GetInnerRadius();
		/*
		 * Sets the inner radius of the skydome
		 * @param pos new inner radius of the skydome
		 */
		void SetInnerRadius(float pos);

		/**
		 * Returns the other radius of the skydome
		 * @return other radius of the skydome
		 */
		float GetOtherRadius();
		/**
		 * Sets the other radius of the skydome
		 * @param pos new other radius of the skydome
		 */
		void SetOtherRadius(float pos);

		/**
		 * Returns the kr parameter
		 * @return kr parameter
		 */
		float GetKr();
		/*
		 * Sets the kr parameter
		 * @param kr kr parameter
		 */
		void SetKr(float kr);

		/**
		 * Returns the km parameter
		 * @return km parameter
		 */
		float GetKm();
		/*
		 * Sets the km parameter
		 * @param km km parameter
		 */
		void SetKm(float km);

		/**
		 * Returns the ESun parameter
		 * @return ESun parameter
		 */
		float GetESun();
		/**
		 * Sets the ESun parameter
		 * @param ESun ESun parameter
		 */
		void SetESun(float ESun);

		/**
		 * Returns the km parameter
		 * @return km parameter
		 */
		float GetG();
		/*
		 * Sets the g parameter
		 * @param g g parameter
		 */
		void SetG(float g);

		/**
		 * Returns the rayleight scale depth parameter
		 * @return rayleight scale depth
		 */
		float GetRayleighScaleDepth();
		/**
		 * Sets the km parameter
		 * @param km km parameter
		 */
		void SetRayleighScaleDepth(float pos);

		/**
		 * This method returns the inverse wavelength
		 * @return inverse wavelength
		 */
		osg::Vec3 GetInverseWaveLength();
		/**
		 * This method sets the inverse wavelength of the skydome
		 * @return view inverse wave length 
		 */
		void SetInverseWaveLength(osg::Vec3 view);

		/**
		 * This method calculates the actual sun color
		 * @return sun color
		 */
		osg::Vec3 CalculateSunColor(osg::Matrixd view);

		/**
		 * This method sets the uniform
		 * @param states StateSet of the node 
		 */
		virtual void SetupUniform(osg::StateSet* states);


	private:
		osg::Vec3 m_invWaveLength;
		float m_km;
		float m_kr;
		float m_ESun;
		float m_g;
		float m_innerR;
		float m_otherR;
		float m_RayleighScaleDepth;	
	};
}