#pragma once
#include <osg/Vec3>
#include <osg/Matrix>
#include <osg/StateSet>
#define PI 3.14159265

namespace osgCloudyDay
{
	class Skydome
	{
	public:
		Skydome(void);
		virtual ~Skydome(void)=0;

		/*
		 * Returns the actual lightposition
		 * @return light position
		 */
		osg::Vec3 GetLightPosition();
		/*
		 * Sets the light position
		 * @param pos new position of the light
		 */
		void SetLightPosition(osg::Vec3 pos);

		/*
		 * This method returns the weighting factor between scene and the light scattering effect
		 * @return inverse wavelength
		 */
		float GetLightScatteringWeight();
		/*
		 * This method sets the the weighting factor between scene and the light scattering effect
		 * @param weight weighting factor
		 */
		void SetLightScatteringWeight(float weight);

		/*
		 * This method returns the density factor for light scattering.
		 * @return density 
		 */
		float GetDensity();
		/*
		 * This method sets the the density factor for light scattering.
		 * @param density weighting factor
		 */
		void SetDensity(float weight);

		/*
		 * This method returns the decay factor for lightscattering
		 * @return decay factor for lightscattering
		 */
		float GetDecay();
		/*
		 * This method sets the the decay factor for light scattering
		 * @param decay factor for lightscattering
		 */
		void SetDecay(float weight);


		/*
		 * This method returns the exposure factor
		 * @return exposure factor
		 */
		float GetExposure();
		/*
		 * This method sets the the exposure factor
		 * @param exposure exporure factor for Tone Mapping
		 */
		void SetExposure(float exposure);

		virtual void SetupUniform(osg::StateSet* nodess4) = 0;

	private:
		osg::Vec3 m_lightPos;

		float m_weight;
		float m_exposure;
		float m_density;
		float m_decay;

	};
}