#pragma once
#include <GL/glew.h>
#include <GL/GL.h>
#include "SkydomeMie.h"
#include "SkydomeHimmel.h"

#include "Fog.h"

#include <osg/Matrix>
#include <osg/MatrixTransform>
#include <osg/Node>
#include <osg/Geometry>
#include <osg/Program>
#include <osg/Geode>
#include <osg/Texture2D>
#include <osg/Image>
#include <osg/BlendFunc>
#include <osg/CullFace>
#include <osgDB/ReadFile>
#include <osg/NodeVisitor>
#include <osg/Texture2D>
#include <osgDB/ReadFile>
#include <osgViewer/Renderer>

#include <osg/Texture2D>
#include <osg/Texture3D>

//#define CREATE_BOUNDINGBOX
#define SHADOW_MAPPING

namespace osgCloudyDay
{
	/**
	 * Class to manage the whole scene
	 */
	class Scene
	{
	public:
		/**
		 * Constructor of scene
		 * @param width window width
		 * @param height window height
		 */
		Scene(int width, int height);

		/** 
		 * Deconstructor
		 */
		~Scene(void);

		/**
		 * Create viewer camera
		 */
		static void CreateViewCamera();
		/**
		 * Create shadow camera
		 */
		static void CreateLightCamera();	
		/**
		 * Create viewer depth camera
		 */
		static void CreateViewDepthCamera();

		/**
		 * Returns view matrix of viewer
		 * @return view matrix
		 */
		static osg::Matrix& GetViewMatrix_View();
		/**
		 * Returns projection matrix of viewer
		 * @return projection matrix
		 */
		static osg::Matrix& GetProjectionMatrix_View();
		/**
		 * Returns projection matrix of shadow
		 * @return projection matrix
		 */
		static osg::Matrix& GetProjectionMatrix_Light();

		/**
		 * Return shadow camera
		 * @return shadow camera
		 */
		static osg::ref_ptr<osg::Camera> GetLightCamera();
		/**
		 * Return viewer camera
		 * @return viewer camera
		 */
		static osg::ref_ptr<osg::Camera> GetViewCamera();
		/**
		 * Return viewer camera
		 * @return viewer camera
		 */
		static osg::ref_ptr<osg::Camera> GetViewCamera2();	
		/**
		 * Return viewer depth camera
		 * @return viewer depth camera
		 */
		static osg::ref_ptr<osg::Camera> GetViewDepthCamera();	

		/**
		 * Set shadow camera
		 *  @param c shadow camera
		 */
		static void SetLightCamera(osg::ref_ptr<osg::Camera> c);
		/**
		 * Set viewer camera
		 *  @param c viewer camera
		 */
		static void SetViewCamera(osg::ref_ptr<osg::Camera> c);					

		/**
		 * This method returns the shadowing shader
		 * @return shadow shader
		 */
		static osg::ref_ptr<osg::Program> GetShadowProgram();
		/**
		 * This method returns the shading shader
		 * @return shading shader
		 */
		static osg::ref_ptr<osg::Program> GetShadingProgram();
		/**
		 * This method returns the debug shader
		 * @return debug shader
		 */
		static osg::ref_ptr<osg::Program> GetDebugProgram();

		/**
		 * This method returns the width of the window
		 * @return width of the window
		 */
		static int GetWidth();
		/**
		 * This method returns the height of the window
		 * @return height of the window
		 */
		static int GetHeight();		

		/**
		 * Method returns the variance shadow map
		 * @return variance shadow map
		 */
		static osg::ref_ptr<osg::Texture2D> GetShadowTexture();	//SHADOW

		/**
		 * Method returns the depth map from the light
		 * @return depth map from light
		 */
		static osg::ref_ptr<osg::Texture2D> GetShadowDepthTexture();	//DEPTH SHADOW
		/**
		 * Method returns the depth map from the viewer
		 * @return depth map from viewer
		 */
		static osg::ref_ptr<osg::Texture2D> GetSceneDepthTexture();	//DEPTH SCENE
		/**
		 * Method returns scene rendererd from viewer
		 * @return scene from viewer
		 */
		static osg::ref_ptr<osg::Texture2D> GetSceneTexture();	//SCENE TEXTURE
		
		/**
		 * Method returns lightshaft texture
		 * @return lightshafts texture
		 */
		static osg::ref_ptr<osg::Texture2D> GetGoodRayTexture();		//GOOD RAYS HELEPR TEXTURE		
		/**
		 * Method returns HUD texture
		 * @return HUD texture
		 */
		static osg::ref_ptr<osg::Texture2D> GetHUDTexture();	//HUD TEXTURE			
		/**
		 * MEthod returns a helper texture for blurring
		 * @return helper texture
		 */
		static osg::ref_ptr<osg::Texture2D> GetBlurTexture();			

		
		static osgCloudyDay::Skydome* m_skydome;			
		static osg::FrameBufferObject* fbo_vert_linear_blur2;
		static osg::FrameBufferObject* fbo_hori_linear_blur2;
		static osg::FrameBufferObject* fbo_scene_viewer;

	protected:		
		static osg::ref_ptr<osg::Texture2D> fbo_light_texture2;	//SHADOW
		static osg::ref_ptr<osg::Texture2D> fbo_goodrays;		//GOOD RAYS HELEPR TEXTURE
		static osg::ref_ptr<osg::Texture2D> fbo_scene_depth;	//DEPTH SCENE
		static osg::ref_ptr<osg::Texture2D> fbo_scene_texture;	//SCENE TEXTURE
		static osg::ref_ptr<osg::Texture2D> fbo_hud_texture;	//HUD TEXTURE			
		static osg::ref_ptr<osg::Texture2D> fbo_blur_texture;	
		static osg::ref_ptr<osg::Texture2D> fbo_light_depth;	//DEPTH SHADOW

		static int m_width;
		static int m_height;

		static osg::ref_ptr<osg::Program> shadowProg;
		static osg::ref_ptr<osg::Program> lightningProg;
		static osg::ref_ptr<osg::Program> debugProg;

		static osg::ref_ptr<osg::Camera> m_ViewCameraDepthOnly;	
		static osg::ref_ptr<osg::Camera> m_ViewCamera;	
		static osg::ref_ptr<osg::Camera> m_LightCamera;	
		static osg::ref_ptr<osg::Camera> m_ViewDepthCamera;			
	};

	class CullCallBackViewCamera3 : public osg::NodeCallback
{
	public:
	CullCallBackViewCamera3(void)
	{

	}

	virtual void operator()(osg::Node* node, osg::NodeVisitor* nv)
	{	
		Scene::GetViewCamera()->setViewMatrix(Scene::GetViewDepthCamera()->getViewMatrix());
		Scene::GetViewCamera()->setProjectionMatrix(Scene::GetViewDepthCamera()->getProjectionMatrix());

		traverse(node, nv);
		
		//Scene::GetViewCamera()->setViewMatrix(Scene::GetViewDepthCamera()->getViewMatrix());
		//Scene::GetViewCamera()->setProjectionMatrix(Scene::GetViewDepthCamera()->getProjectionMatrix());
	}

};
	class CullCallBackViewCamera2 : public osg::NodeCallback
{
	public:
	CullCallBackViewCamera2(void)
	{

	}

	virtual void operator()(osg::Node* node, osg::NodeVisitor* nv)
	{
		osg::Vec3 e;
		osg::Vec3 c;
		osg::Vec3 u;
		Scene::GetViewDepthCamera()->getViewMatrixAsLookAt(e,c,u);

		Scene::GetViewCamera2()->setViewMatrix(Scene::GetViewDepthCamera()->getViewMatrix());
		Scene::GetViewCamera2()->setProjectionMatrix(Scene::GetViewDepthCamera()->getProjectionMatrix());
		Scene::GetViewCamera()->setViewMatrix(Scene::GetViewDepthCamera()->getViewMatrix());
		Scene::GetViewCamera()->setProjectionMatrix(Scene::GetViewDepthCamera()->getProjectionMatrix());
		traverse(node, nv);
	}

};
	class CullCallBackViewCamera5 : public osg::NodeCallback
{
	public:
	CullCallBackViewCamera5(void)
	{

	}

	virtual void operator()(osg::Node* node, osg::NodeVisitor* nv)
	{	
		osgUtil::CullVisitor* cv = dynamic_cast<osgUtil::CullVisitor*>(nv);	   		
		cv->getCurrentCamera()->setViewMatrix(Scene::GetViewMatrix_View());

		traverse(node, nv);
	}
};
	class CullCallBackViewCamera6 : public osg::NodeCallback
{
	public:
	CullCallBackViewCamera6(void)
	{

	}

	virtual void operator()(osg::Node* node, osg::NodeVisitor* nv)
	{
		osgUtil::CullVisitor* cv = dynamic_cast<osgUtil::CullVisitor*>(nv);	   		
		cv->getCurrentCamera()->setViewMatrix(Scene::GetViewMatrix_View());
		traverse(node, nv);
	}
};
	class CullCallBackViewCamera4 : public osg::NodeCallback
{
	public:
	CullCallBackViewCamera4(void)
	{

	}

	virtual void operator()(osg::Node* node, osg::NodeVisitor* nv)
	{
		traverse(node, nv);
	}
};
	class CullCallBackViewCamera : public osg::NodeCallback
{
	public:
	CullCallBackViewCamera(void)
	{

	}

	virtual void operator()(osg::Node* node, osg::NodeVisitor* nv)
	{
		traverse(node, nv);
	}
};

	class ViewerLightTerrainCallback : public osg::NodeCallback
{
public:
	ViewerLightTerrainCallback(void)
	{

	}

	virtual void operator()(osg::Node* node, osg::NodeVisitor* nv)
	{
		osgUtil::CullVisitor* cv = dynamic_cast<osgUtil::CullVisitor*>(nv);	   
		osg::ref_ptr<osg::Geode> geometry = dynamic_cast<osg::Geode*> (node);

		if(geometry && cv)
		{
			osg::Vec3f eye = osg::Vec3f();
			osg::Vec3f center = osg::Vec3f();
			osg::Vec3f up = osg::Vec3f();
			Scene::GetLightCamera()->getViewMatrixAsLookAt(eye, center, up);		
			
			osg::Matrixd view(cv->getCurrentCamera()->getViewMatrix());
			osg::Matrixd invViewMatrix = osg::Matrixd::inverse(view);
			osg::Matrixd modelview(*cv->getModelViewMatrix());
			osg::Matrixd model = modelview*invViewMatrix;
			osg::Matrixd proj(cv->getCurrentCamera()->getProjectionMatrix());
		
			geometry->getOrCreateStateSet()->getUniform("ModelMatrix")->set(model);
			geometry->getOrCreateStateSet()->getUniform("ViewMatrix")->set(view);
			geometry->getOrCreateStateSet()->getUniform("ProjectionMatrix")->set(proj);		

#ifdef SHADOW_MAPPING
			geometry->getOrCreateStateSet()->getUniform("light_proj_matrix")->set(Scene::GetProjectionMatrix_Light());
			geometry->getOrCreateStateSet()->getUniform("light_mv_matrix")->set(Scene::GetLightCamera()->getViewMatrix());
#endif
		}
		traverse(node, nv);
	}
};

	class ViewerLightCallback : public osg::NodeCallback
{
public:
	ViewerLightCallback(void)
	{

	}

	virtual void operator()(osg::Node* node, osg::NodeVisitor* nv)
	{
		osgUtil::CullVisitor* cv = dynamic_cast<osgUtil::CullVisitor*>(nv);	   
		osg::ref_ptr<osg::Geode> geometry = dynamic_cast<osg::Geode*> (node);

		if(geometry && cv)
		{
			osg::Matrixd view(cv->getCurrentCamera()->getViewMatrix());
			osg::Matrixd invViewMatrix = osg::Matrixd::inverse(view);
			osg::Matrixd modelview(*cv->getModelViewMatrix());
			osg::Matrixd model = modelview*invViewMatrix;
			osg::Matrixd proj(cv->getCurrentCamera()->getProjectionMatrix());
		
			geometry->getOrCreateStateSet()->getUniform("ModelMatrix")->set(model);
			geometry->getOrCreateStateSet()->getUniform("ViewMatrix")->set(Scene::GetViewMatrix_View());
			geometry->getOrCreateStateSet()->getUniform("ProjectionMatrix")->set(Scene::GetProjectionMatrix_View());		

			//geometry->getOrCreateStateSet()->getUniform("light_mv_matrix")->set(Scene::GetViewMatrix_Light());		
			//geometry->getOrCreateStateSet()->getUniform("light_proj_matrix")->set(Scene::GetProjectionMatrix_Light());		
			
			//geometry->getOrCreateStateSet()->getUniform("ViewMatrix")->set(Scene::GetViewMatrix_View());
			//geometry->getOrCreateStateSet()->getUniform("ViewMatrix")->set(camera_plane_cubemap[0]->getViewMatrix());			
			//geometry->getOrCreateStateSet()->getUniform("ProjectionMatrix")->set(Scene::GetProjectionMatrix_View());					
			
			/*
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("v3LightPos", Scene::m_skydome->GetLightPosition()));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("v3InvWavelength", osg::Vec3(1.f/powf(Scene::m_skydome->GetInverseWaveLength().x(), 4.f), 1.f/powf(Scene::m_skydome->GetInverseWaveLength().y(), 4.f), 1.f/powf(Scene::m_skydome->GetInverseWaveLength().z(), 4.f))));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("fOuterRadius", Scene::m_skydome->GetOtherRadius()));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("fOuterRadius2", powf(Scene::m_skydome->GetOtherRadius(),2.f)));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("fInnerRadius", Scene::m_skydome->GetInnerRadius()));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("fInnerRadius2", powf(Scene::m_skydome->GetInnerRadius(),2.f)));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("fKrESun", Scene::m_skydome->GetKr()*Scene::m_skydome->GetESun()));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("fKmESun", Scene::m_skydome->GetKm()*Scene::m_skydome->GetESun()));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("fKr4PI", Scene::m_skydome->GetKr()*4.f*(float)PI));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("fKm4PI", Scene::m_skydome->GetKm()*4.f*(float)PI));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("fScale", 1.f / (Scene::m_skydome->GetOtherRadius() - Scene::m_skydome->GetInnerRadius())));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("fScaleDepth", Scene::m_skydome->GetRayleighScaleDepth()));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("fScaleOverScaleDepth", (1.f / (Scene::m_skydome->GetOtherRadius() - Scene::m_skydome->GetInnerRadius())) / Scene::m_skydome->GetRayleighScaleDepth()));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("g", Scene::m_skydome->GetG()));
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("g2", (powf(Scene::m_skydome->GetG(),2.f))));
			
			geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("color_tex", 0));	*/

#ifdef SHADOW_MAPPING
			geometry->getOrCreateStateSet()->getUniform("light_proj_matrix")->set(Scene::GetProjectionMatrix_Light());
			geometry->getOrCreateStateSet()->getUniform("light_mv_matrix")->set(Scene::GetLightCamera()->getViewMatrix());
#endif
		}
		traverse(node, nv);
	}
};
}