#pragma once
#include "Scene.h"
#include <osg/FrameBufferObject>
#include <osg/TextureCubeMap>

namespace osgCloudyDay
{
	/**
	 * Class updates the uniforms at runtime
	 */
	class ViewerLightCallbackTest : public osg::NodeCallback
	{
	public:
		/**
		 * Constructor
		 */
		ViewerLightCallbackTest(void)
		{

		}

		/**
		 * Method updates the unifomrs at runtime
		 */
		virtual void operator()(osg::Node* node, osg::NodeVisitor* nv)
		{
			osgUtil::CullVisitor* cv = dynamic_cast<osgUtil::CullVisitor*>(nv);	   
			osg::ref_ptr<osg::Geode> geometry = dynamic_cast<osg::Geode*> (node);

			if(geometry && cv)
			{
				osg::Matrixd view(cv->getCurrentCamera()->getViewMatrix());
				osg::Matrixd invViewMatrix = osg::Matrixd::inverse(view);
				osg::Matrixd model(*cv->getModelViewMatrix());
				model = model*invViewMatrix;
				osg::Matrixd proj(cv->getCurrentCamera()->getProjectionMatrix());
		
				geometry->getOrCreateStateSet()->getUniform("ModelMatrix")->set(model);
				geometry->getOrCreateStateSet()->getUniform("ViewMatrix")->set(view);
				geometry->getOrCreateStateSet()->getUniform("ProjectionMatrix")->set(proj);		

				geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("v3LightPos", osgCloudyDay::Scene::m_skydome->GetLightPosition()));
				osgCloudyDay::Scene::m_skydome->SetupUniform(geometry.get()->getOrCreateStateSet());			
				geometry->getOrCreateStateSet()->addUniform(new osg::Uniform("color_tex", 0));					

	#ifdef SHADOW_MAPPING
				geometry->getOrCreateStateSet()->getUniform("light_proj_matrix")->set(osgCloudyDay::Scene::GetProjectionMatrix_Light());
				geometry->getOrCreateStateSet()->getUniform("light_mv_matrix")->set(osgCloudyDay::Scene::GetLightCamera()->getViewMatrix());
	#endif
			}
			traverse(node, nv);
		}
	};


	/**
	 * Class, creates a reflection camera
	 */
	class ReflectionCamera
	{
	public:
		/**
		 * Constructor
		 */
		ReflectionCamera(void);
		/**
		 * Deconstructor
		 */
		~ReflectionCamera(void);

		/**
		 * Method initialize the refleciton camera
		 */
		void Initialize();
		/**
		 * Method adds an object with reflections
		 * @param geo object geode
		 */
		void AddObject(osg::ref_ptr<osg::Geode> geo);
		
		osg::ref_ptr<osg::TextureCubeMap> fbo_plane_cube;
		osg::ref_ptr<osg::TextureCubeMap> fbo_plane_cube_depth;

		/**
		 * Method returns the reflection camera
		 * @return camera
		 */
		osg::Camera**& GetCamera();

	protected:
		osg::Camera** camera_plane_cubemap;	
	};
}