#pragma once
#include <osg/Vec3>

namespace osgCloudyDay
{
	/**
	 * Class, which manages the states of a rainy region
	 */
	class RainState
	{
	public:
		/**
		 * Constructor
		 */
		RainState();
		/**
		 * Deconstructor
		 */
		~RainState();

		/**
		 * Method sets the number of particles of a rainy region (i.e. intensity of a rain)
		 * @param numberOfParticles number of particles
		 */
		void SetNumberOfParticles(unsigned int numberOfParticles);
		/**
		 * Method returns the number of particles (i.e. the intensity of a rainy region)
		 * @return number of particles
		 */
		unsigned int GetNumberOfParticles();

		/**
		 * Method sets the velocity of a rainy region
		 * @param velocity velocity of the region
		 */
		void SetVelocity(osg::Vec3 velocity);
		/**
		 * Method returns the velocity of a rainy region
		 * @return velocity
		 */
		osg::Vec3 GetVelocity();

		/**
		 * Method sets the position of a rainy region
		 * @param position position of the region
		 */
		void SetPosition(osg::Vec3 position);
		/**
		 * Method returns the positon of a rainy region
		 * @return position
		 */
		osg::Vec3 GetPosition();

		/**
		 * Method sets the size of a rainy region
		 * @param size size of the region
		 */
		void SetSize(osg::Vec3 size);
		/**
		 * Method returns the size of a rainy region
		 * @return size
		 */
		osg::Vec3 GetSize();
	protected:
		unsigned int m_numberOfParticles;
		osg::Vec3 m_velocity;
		osg::Vec3 m_middlepos;
		osg::Vec3 m_size;
	};
}