#pragma once
#include "hud.h"

namespace osgCloudyDay
{
	/**
	 * Postprocess class: This class add the bloom effect, the star effet, performs the final hdr tone mapping, and the LUD mapping.
	 * Addionally, a vignette effect is availible
	 */
	class PostProcess :	public osgCloudyDay::HUD
	{
	public:
		/** 
		 * Enumeration, which defines the hdr mapping technique.
		 * HDRM_Linear: linear mapping
		 * HDRM_Reinhard: Reinhard HDR mapping
		 * HDRM_ReinhardModified: Modified Reinhard HDR mapping (recommended)
		 * HDRM_Uncharted: Uncharted HDR mapping
		 */
		enum HDR_Mapping
		{
			HDRM_Linear,
			HDRM_Reinhard,
			HDRM_ReinhardModified,
			HDRM_Uncharted
		};		

		/**
		 * Constructor
		 * @param hdr_mapping HDR mapping technique (see enumeration)
		 * @param use_avglum Should average luminance calculated
		 * @param use_bloom Should the bloom effect be caluculated
		 * @param use_star Should the star effect be calculated
		 */
		PostProcess(int hdr_mapping, bool use_avglum, bool use_bloom, bool use_star);
		/**
		 * Deconstructor
		 */
		~PostProcess(void);

		/**
		 * Method to set the uniforms of the geode
		 * @param states States of the geode
		 */
		virtual void SetupUniform(osg::ref_ptr<osg::StateSet> states);
		/**
		 * Method to set the textures of the geode
		 * @param states States of the geode
		 */
		virtual void SetupTextures(osg::ref_ptr<osg::StateSet> states);

		/**
		 * Method to create the camera
		 */
		virtual void CreateCamera();

		/**
		 * Method to add an addidional lud
		 * @param path path to the LUD.
		 */
		void AddLUD(std::string path);

	protected:	
		int m_HDRMapping;

		bool m_use_AVGLuminance;
		bool m_use_vignette;

		const std::string GetGLSLFragmentShader();
		const std::string GetGLSLVertexShader();

		const std::string GetGLSLAssignLUD();
		const std::string GetGLSLUniformLUD();
		const std::string GetGLSLFragmentUncharted();
		const std::string GetGLSLFragmentVignetteFunc();
		const std::string GetGLSLFragmentMainFunc();
		const std::string GetHDRMapping();
		const std::string GetGlare();
		const std::string GetVignette();
		const std::string GetSRGB();

		const std::string GetGLSLFragmentHeader();		

		osg::ref_ptr<osg::Texture2D> m_postprocess;
		osg::ref_ptr<osg::Texture3D> tex3dlud;

		std::vector<osg::ref_ptr<osg::Texture3D>> m_lods;

		int num_lods;

		bool m_bloom;
		bool m_star;
	};
}