#pragma once
#include "Cloud2D.h"
#include <osg/Geometry>
#include <osg/Geode>
#include <osg/Texture2D>
#include <osg/Image>
#include <osgUtil/SmoothingVisitor>
#include <osgUtil/TangentSpaceGenerator>
#include <osg/BlendFunc>
#include <osgDB/ReadFile>

#include <cstdlib>
#include <iostream>
#include <math.h>
#include <stdio.h>

//Umsetzung von:
//Wolken (Geometry, Idee): http://freespace.virgin.net/hugo.elias/models/m_clouds.htm
//Perlin Noise: http://freespace.virgin.net/hugo.elias/models/m_perlin.htm
//NormalMap: http://code.google.com/p/gimp-normalmap/source/browse/trunk/normalmap.c
//+ Parallax Mapping

namespace osgCloudyDay
{
	/**
	 * Class to create a 2D cloud with a Perlin noise cloud
	 * Results in a altcumolus cloud
	 */
	class PerlinNoiseCloud : public osgCloudyDay::Cloud2D
	{
	public:
		/**
		 * Constructor
		 */
		PerlinNoiseCloud(void);
		/**
		 * Deconstructor
		 */
		~PerlinNoiseCloud(void);

		/**
		 * Initialize method
		 */
		void Initialize();
		
		/**
		 * Creates the Perlin noise cloud for rendering
		 * @param position position of the 2d cloud
		 * @param size size of the 2d cloud
		 * @param vertices vertices of the 2D cloud
		 * @param tcoords texture coordinates of the 2D cloud
		 * @param indices indices of the 2D cloud
		 */
		virtual void SetupGeometry(osg::Vec3 position, osg::Vec2 size, osg::Vec3Array* vertices, osg::Vec2Array* tcoords, osg::UIntArray* indices);

	protected:
		/**
		 * Method to create a 2D Perlin noise texture
		 * @param width width of the texture
		 * @param height height of the texture
		 * @param color color texture
		 * @param normal normal texture
		 */
		void CreatePerlinTexture2D(int width, int height, osg::Image* color, osg::Image* normal);

		/**
		 * Sets the noise values
		 * @param map noise values
		 */
		void SetNoise(float  *map);

		/**
		 * Returns noise value at a specific coordinate
		 * @param x x-coordinate
		 * @param y y-coordinate
		 * @return noise value
		 */
		float Noise(int x, int y);
		/**
		 * Returns smoothed noise value at a specific coordinate
		 * @param x x-coordinate
		 * @param y y-coordinate
		 * @return smoothed noise value
		 */
		float SmoothedNoise(float x, float y);
		/**
		 * Returns the cosine interpolated noise value at a specific coordinate
		 * @param x x-coordinate
		 * @param y y-coordinate
		 * @param x value
		 * @return smoothed noise value
		 */
		float Cosine_Interpolate(float a, float b, float x);
		/**
		 * Returns the interpolated noise value at a specific coordinate
		 * @param x x-coordinate
		 * @param y y-coordinate
		 * @return interpolated noise value
		 */
		float InterpolatedNoise(float x, float y);
		/**
		 * Returns the perlin noise value at a specific coordinate
		 * @param x x-coordinate
		 * @param y y-coordinate
		 * @return Perlin noise value
		 */
		float PerlinNoise(float x, float y);
	};
}