#pragma once
#include "Cloud2DState.h"

namespace osgCloudyDay
{
	/**
	 * Class to configure a 2D cloud, created with a Perlin noise generator
	 */
	class PerlinCloudState : public osgCloudyDay::Cloud2DState
	{
	public:
		/**
		 * Constructor
		 */
		PerlinCloudState(void);
		/**
		 * Deconstructor
		 */
		~PerlinCloudState(void);

		/** 
		 * Returns the number of Layers 
		 * @return number of layers
		 */
		int getNumberOfLayers();
		/** 
		 * Sets the number of Layers 
		 * @param numOfLayers number of layers
		 */
		void setNumberOfLayers(int numOfLayers);

		/** 
		 * Returns the cover attribute
		 * @return cover attribute
		 */
		float getCover();
		/** 
		 * Sets the cover attribute
		 * @param cover cover attribute
		 */
		void setCover(float cover);

		/** 
		 * Returns the sharpness attribute
		 * @return sharpness attribute
		 */
		float getSharpness();
		/** 
		 * Sets the sharpness attribute
		 * @param sharpness sharpness attribute
		 */
		void setSharpness(float sharpness);	

	protected:
		int m_numberOfLayers;
		float m_cover;
		float m_sharpness;
	};
}