#pragma once
#include "Scene.h"
#include <osg/TextureCubeMap>

namespace osgCloudyDay
{
	/**
	 * Class, which updates the uniforms
	 */
	class ViewerLightCallbackTransform : public osg::NodeCallback
	{
	public:
		/**
		* Constructor
		*/
		ViewerLightCallbackTransform(void)
		{

		};

		/**
		 * Updates the uniforms
		 */
		virtual void operator()(osg::Node* node, osg::NodeVisitor* nv);
	};

	/**
	* Class to render a 3D model
	*/
	class ObjectModel
	{
	public:
		/**
		 * Constructor
		 */
		ObjectModel(void);
		/**
		 * Deconstructor
		 */
		~ObjectModel(void);

		/**
		 * Initialize method
		 * @param id identity, which is to define the LUD
		 * @param path path to 3D model
		 * @param path_tex path to texture
		 * @param fbo_plane_cube reflection texture
		 */
		void Initialize(int id, std::string path, std::string path_tex, osg::ref_ptr<osg::TextureCubeMap>& fbo_plane_cube);

		/**
		 * Returns the geode to render it from the light source
		 * @return geode
		 */
		osg::ref_ptr<osg::MatrixTransform> LightNode();
		/**
		 * Returns the geode to render it from the viewer
		 * @return geode
		 */
		osg::ref_ptr<osg::MatrixTransform> ViewNode();

	protected:	
		osg::ref_ptr<osg::Group> scene;
		osg::ref_ptr<osg::Group> lightView_scene;

		osg::MatrixTransform* trans;
		osg::MatrixTransform* trans2;
		int m_id;

	};
}
