#pragma once
#include "CloudGenerator.h"

namespace osgCloudyDay
{
	/**
	 * Class to create a cloud looking like a 3d model.
	 * We use a ray casting approach to create the cloud.
	 */
	class ObjCloud : public CloudGenerator
	{
	public:
		/**
		 * Standardconstructor
		 * @param path path to the model
		 * @param pos position of the cloud
		 * @param type type of the cloud
		 * @param layer colour of the cloud
		 */
		ObjCloud(std::string path, osg::Vec3 pos, int type, osg::Vec4 layer);
		/**
		 * Standarddeconstructor
		 */
		~ObjCloud(void);
	
	protected:
		/**
		 * Initialize creates the boxes and sprites which are needed to create a cloud.
		 */
		void Initialize();

		/**
		 * Updates the cloud
		 */
		bool Update();

		osg::Vec3 m_middlepos;

	private:
		CloudCreateVolume* volume;
	};
}