#pragma once
#include "CloudGenerator.h"

namespace osgCloudyDay
{
	/**
	 * Nimbosstratus Generator: Generates static nimbostratus cloud
	 */
	class NimbostratusGenerator : public CloudGenerator
	{
	public:
		/**
		 * Standardconstructor
		 * @param color color of the cloud.
		 */
		NimbostratusGenerator(osg::Vec4 layer);
		/**
		 * Standarddeconstructor
		 */
		~NimbostratusGenerator(void);

	protected:
		/**
		 * Initialize creates the boxes and sprites which are needed to create a Cumulus cloud.
		 */
		void Initialize();

		/**
		 * Updates the cloud
		 */
		bool Update();

		int m_type;
	};
}