#pragma once
#include "Scene.h"
#include <osg/Geometry>
#include <osg/State>
#include <osg/ArrayDispatchers>
#include <osg/PrimitiveSet>
#include <osg/Shader>
#include <osg/Program>

#include <osg/ClearNode>
#include <osgViewer/Viewer>
#include <osg/GL>
#include <osgUtil/RenderStage>
#include <osg/PolygonOffset>
#include <osg/BlendFunc>
#include <osg/BlendEquation>
#include <osg/Depth>

#include <osg/Shader>
#include <osg/Vec3>
#include <osg/Matrix>

namespace osgCloudyDay
{
	/**
	 * NOT USED NOW
	 */
	class NightLightCallback : public osg::NodeCallback
	{
	public:
		NightLightCallback(void)
		{

		}

		virtual void operator()(osg::Node* node, osg::NodeVisitor* nv)
		{
			osgUtil::CullVisitor* cv = dynamic_cast<osgUtil::CullVisitor*>(nv);	   
			osg::ref_ptr<osg::Geode> geometry = dynamic_cast<osg::Geode*> (node);

			if(geometry && cv)
			{
				osg::Matrixd view(cv->getCurrentCamera()->getViewMatrix());
				osg::Matrixd invViewMatrix = osg::Matrixd::inverse(view);
				osg::Matrixd modelview(*cv->getModelViewMatrix());
				osg::Matrixd model = modelview*invViewMatrix;
				osg::Matrixd proj(cv->getCurrentCamera()->getProjectionMatrix());
		
				geometry->getOrCreateStateSet()->getUniform("ModelMatrix")->set(model);
				geometry->getOrCreateStateSet()->getUniform("ViewMatrix")->set(view);
				geometry->getOrCreateStateSet()->getUniform("ProjectionMatrix")->set(proj);		

				geometry->getOrCreateStateSet()->getUniform("light_mv_matrix")->set(osgCloudyDay::Scene::GetLightCamera()->getViewMatrix());		
		

	#ifdef SHADOW_MAPPING
				geometry->getOrCreateStateSet()->getUniform("light_proj_matrix")->set(osgCloudyDay::Scene::GetProjectionMatrix_Light());
				geometry->getOrCreateStateSet()->getUniform("light_mv_matrix")->set(osgCloudyDay::Scene::GetLightCamera()->getViewMatrix());
	#endif
			}
			traverse(node, nv);
		}
	};

	/**
	 * NOT USED NOW
	 */
	class Night
	{
	public:
		Night();
		~Night();

		void Initialize();
		void SetArrays();
		static void CreateShader();
		void SetUniforms(osg::ref_ptr<osg::StateSet> nodess4);
	
		static void CreateTexture();

		static osg::ref_ptr<osg::Program> m_cloudProg;
		static osg::ref_ptr<osg::Texture2D> tex_tree;
	
		osg::Geode* GetGeode();		

	protected:
		osg::ref_ptr<osg::Geode> geode;
		osg::ref_ptr<osg::Geometry> geometry;
		osg::ref_ptr<osg::Vec3Array> m_vertices;
		osg::ref_ptr<osg::Vec4Array> m_information;
		osg::ref_ptr<osg::UIntArray> m_indices;	

		int m_num_stars;
	};
}