#pragma once
#include "hud.h"

namespace osgCloudyDay
{
	/**
	 * Class to create the average luminance of the scene
	 */
	class LuminanceCalculation : public osgCloudyDay::HUD
	{
	public:
		/**
		 * Constructor
		 */
		LuminanceCalculation(void);

		/**
		 * Deconstructor
		 */
		~LuminanceCalculation(void);

		/**
		 * Method to set the states of the node
		 * @param states StateSet of the Node
		 */
		virtual void SetupUniform(osg::ref_ptr<osg::StateSet> states);

		/**
		 * Method to set the textures of the node
		 * @param states StateSet of the NOde
		 */
		virtual void SetupTextures(osg::ref_ptr<osg::StateSet> states);

		/**
		 * Method which creates the post-process camera
		 */
		virtual void CreateCamera();
	
	protected:
	};
}