#pragma once
#include <osg/Geometry>

namespace osgCloudyDay
{
	/**
	 * Geometry class to render Lightshafts
	 */
	class LightShaftGeometry : public osg::Geometry
	{
	public:
		/**
		 * Constructor
		 */
		LightShaftGeometry(void);
		/**
		 * Copy constructor
		 */
		LightShaftGeometry(osg::Geometry& geo);
		/**
		 * Deconstructor
		 */
		virtual ~LightShaftGeometry(void);

		/**
		 * Render light shafts
		 */
		virtual void drawImplementation(osg::RenderInfo& renderInfo) const;

	protected:
		//bool test;
		
		typedef void (GL_APIENTRY * GLBlendEquationiProc)(GLuint buf, GLenum mode);
		static GLBlendEquationiProc _glBlendEquationi;
	};
}
