#pragma once
#include "Scene.h"

#include <osg/Geode>
#include <osg/Geometry>
#include <osg/Array>
#include <osg/CullFace>
#include <osg/Depth>

namespace osgCloudyDay
{
	/**
	 * NOT USED NOW
	 */
	class LightShaft2Callback : public osg::NodeCallback
	{
	public:
		LightShaft2Callback(void)
		{

		}

		virtual void operator()(osg::Node* node, osg::NodeVisitor* nv)
		{
			osgUtil::CullVisitor* cv = dynamic_cast<osgUtil::CullVisitor*>(nv);	   
			osg::ref_ptr<osg::Geode> geometry = dynamic_cast<osg::Geode*> (node);

			if(geometry && cv)
			{
				osg::Matrixd view(cv->getCurrentCamera()->getViewMatrix());
				osg::Matrixd invViewMatrix = osg::Matrixd::inverse(view);
				osg::Matrixd modelview(*cv->getModelViewMatrix());
				osg::Matrixd model = modelview*invViewMatrix;
				osg::Matrixd proj(cv->getCurrentCamera()->getProjectionMatrix());
		
				geometry->getOrCreateStateSet()->getUniform("ModelMatrix")->set(model);
				geometry->getOrCreateStateSet()->getUniform("ViewMatrix")->set(view);
				geometry->getOrCreateStateSet()->getUniform("ProjectionMatrix")->set(proj);		

				geometry->getOrCreateStateSet()->getUniform("light_mv_matrix")->set(osgCloudyDay::Scene::GetLightCamera()->getViewMatrix());		
				geometry->getOrCreateStateSet()->getUniform("light_proj_matrix")->set(osgCloudyDay::Scene::GetProjectionMatrix_Light());
				geometry->getOrCreateStateSet()->getUniform("light_mv_matrix")->set(osgCloudyDay::Scene::GetLightCamera()->getViewMatrix());



				double ratio, angle, nearD, farD;
				osg::Vec3 p, l, u;
				cv->getCurrentCamera()->getProjectionMatrix().getPerspective(angle, ratio, nearD, farD);				
				cv->getCurrentCamera()->getViewMatrix().getLookAt(p, l, u);

				float tang = (float)tan(angle* PI/180.f * 0.5) ;
				float nh = nearD * tang;
				float nw = nh * ratio; 
				float fh = farD  * tang;
				float fw = fh * ratio;

				osg::Vec3 dir,nc,fc,X,Y,Z;
				Z = p - l;
				Z.normalize();

				X = u ^ Z;				
				X.normalize();

				Y = Z ^ X;

				nc = p - Z * nearD;
				fc = p - Z * farD;

				osg::Vec3 ntl = nc + Y * nh - X * nw;
				osg::Vec3 ntr = nc + Y * nh + X * nw;
				osg::Vec3 nbl = nc - Y * nh - X * nw;
				osg::Vec3 nbr = nc - Y * nh + X * nw;

				osg::Vec3 ftl = fc + Y * fh - X * fw;
				osg::Vec3 ftr = fc + Y * fh + X * fw;
				osg::Vec3 fbl = fc - Y * fh - X * fw;
				osg::Vec3 fbr = fc - Y * fh + X * fw;				
				
				geometry->getOrCreateStateSet()->getUniform("planeLBN")->set(osg::Vec4f(nbl.x(), nbl.y(), nbl.z(), 1.f));			
				geometry->getOrCreateStateSet()->getUniform("planeRBN")->set(osg::Vec4f(nbr.x(), nbr.y(), nbr.z(), 1.f));
				geometry->getOrCreateStateSet()->getUniform("planeLTN")->set(osg::Vec4f(ntl.x(), ntl.y(), ntl.z(), 1.f));
				geometry->getOrCreateStateSet()->getUniform("planeRTN")->set(osg::Vec4f(ntr.x(), ntr.y(), ntr.z(), 1.f));
				geometry->getOrCreateStateSet()->getUniform("planeLBT")->set(osg::Vec4f(fbl.x(), fbl.y(), fbl.z(), 1.f));
				geometry->getOrCreateStateSet()->getUniform("planeRBT")->set(osg::Vec4f(fbr.x(), fbr.y(), fbr.z(), 1.f));
				geometry->getOrCreateStateSet()->getUniform("planeLTT")->set(osg::Vec4f(ftl.x(), ftl.y(), ftl.z(), 1.f));
				geometry->getOrCreateStateSet()->getUniform("planeRTT")->set(osg::Vec4f(ftr.x(), ftr.y(), ftr.z(), 1.f));
			}
			traverse(node, nv);
		}
	};

	/**
	 * Creation of Lightshafts using Dobiashi method
	 * The planes are created to fit within the viewing frustrum
	 */
	class LightShaft2
	{
	public:
		LightShaft2();
		~LightShaft2();

		void Initialize();
		osg::Geode* GetGeode();	
		void SetUniforms(osg::ref_ptr<osg::StateSet> nodess4);

	protected:
		osg::ref_ptr<osg::Geode> geode;
		osg::ref_ptr<osg::Geometry> geometry;
		osg::ref_ptr<osg::Vec3Array> m_vertices;
		osg::ref_ptr<osg::UIntArray> m_indices;	
		osg::ref_ptr<osg::Program> m_forestProg;
	};
}